<?php

namespace App\Policies;

use App\Models\Consultation;
use App\Models\User;

class ConsultationPolicy
{
    public function view(User $user, Consultation $consultation): bool
    {
        if ($user->role?->value === 'superadmin') return true;

        $patientCompanyId = $consultation->patient?->company_id
            ?? $consultation->patient?->parent?->company_id;

        return $patientCompanyId
            ? $user->hasCompanyAccess($patientCompanyId)
            : false;
    }

    public function update(User $user, Consultation $consultation): bool
    {
        return $this->view($user, $consultation);
    }

    public function delete(User $user, Consultation $consultation): bool
    {
        return $this->view($user, $consultation);
    }
}
