<?php

use App\Http\Controllers\MonthlyDispenseReportController;
use App\Http\Middleware\HandleAppearance;
use App\Http\Middleware\HandleInertiaRequests;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Http\Middleware\AddLinkHeadersForPreloadedAssets;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->encryptCookies(except: ['appearance', 'sidebar_state']);

        $middleware->web(append: [
            HandleAppearance::class,
            HandleInertiaRequests::class,
            AddLinkHeadersForPreloadedAssets::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })
    ->withSchedule(function (Schedule $schedule) {
        $schedule->call(function () {
            if (! class_exists(\ZipArchive::class)) {
                Log::error('DailyDispense: PHP zip extension missing. Enable extension=zip.');
                return;
            }

            // call your controller method with a fresh Request
            app(MonthlyDispenseReportController::class)->emailDaily(new Request());
        })
            ->name('daily-dispensations-email')
            ->dailyAt('17:30')
            ->timezone('Africa/Harare')
            ->withoutOverlapping();
    })
    ->withSchedule(function (Illuminate\Console\Scheduling\Schedule $schedule) {
        $schedule->call(function () {
            if (! class_exists(\ZipArchive::class)) {
                Log::error('DailyNurseConsultations: PHP zip extension missing. Enable extension=zip.');
                return;
            }
            app(App\Http\Controllers\EmployeeReportsController::class)
                ->emailNurseDailyConsultations(new Illuminate\Http\Request());
        })
            ->name('daily-nurse-consultations-email') // required when using withoutOverlapping()
            ->dailyAt('17:30')
            ->timezone('Africa/Harare')
            ->withoutOverlapping();
    })

    ->create();
