<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Clinic>
 */
class ClinicFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->company . ' Clinic',
            'address' => $this->faker->address,
            'city' => $this->faker->city,
            'afhoz_number' => 'AFZ' . $this->faker->unique()->numberBetween(100, 999),
            'contact_person' => $this->faker->name,
            'manager' => 'Dr. ' . $this->faker->name,
            'country' => $this->faker->country,
            'email_address' => $this->faker->unique()->safeEmail,
        ];
    }
}
