<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('middle_name');
            $table->string('surname');
            $table->string('employee_number')->nullable();
   +                                                         // For main patients
            $table->date('emp_start_date')->nullable();                                                  // NEW
            $table->date('emp_end_date')->nullable();
                                                                // NEW
            $table->foreignId('company_id')->nullable()->constrained()->nullOnDelete();                  // For main patients
            $table->foreignId('parent_patient_id')->nullable()->constrained('patients')->nullOnDelete(); // For dependents
            $table->date('date_of_birth')->nullable();
            $table->string('email')->nullable();
            $table->string('gender')->nullable();
            $table->string('id_number')->nullable(); // National ID / Passport
            $table->string('medical_aid_number')->nullable();
            $table->string('medical_aid_provider')->nullable();
            $table->string('relationship')->nullable();
            $table->string('phone')->nullable();
            $table->string('emergency_contact_name')->nullable();
            $table->string('emergency_contact_relation')->nullable();
            $table->string('emergency_contact_phone')->nullable();
            $table->text('allergies')->nullable();
            $table->boolean('is_smoker')->nullable();
            $table->string('occupation')->nullable();
            $table->string('marital_status')->nullable();

            $table->boolean('is_chronic_patient')->nullable();

            $table->text('home_address')->nullable();
            $table->string('suburb')->nullable();
            $table->string('work_area')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patients');
    }
};

