<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('consultations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->cascadeOnDelete();
            $table->foreignId('doctor_id')->nullable()->constrained('users')->nullOnDelete(); // if linked to a specific doctor
            $table->foreignId('clinic_id')->nullable()->constrained()->nullOnDelete();        // if linked to a specific clinic
            $table->date('consultation_date');
            $table->boolean('injury_on_duty')->default(false);

                                                                  // Vitals
            $table->unsignedSmallInteger('systolic')->nullable(); // e.g., 120
            $table->unsignedSmallInteger('diastolic')->nullable();
            $table->decimal('temperature', 4, 1)->nullable();       // e.g., 37.2°C
            $table->decimal('heart_rate', 5, 2)->nullable();        // bpm
            $table->decimal('respiratory_rate', 5, 2)->nullable();  // breaths per minute
            $table->decimal('oxygen_saturation', 5, 2)->nullable(); // %
            $table->decimal('weight', 6, 2)->nullable();            // in kg
            $table->decimal('height', 6, 2)->nullable();            // in cm
            $table->decimal('bmi', 5, 2)->nullable();

                                                              // Labs / Tests
            $table->decimal('blood_sugar', 5, 2)->nullable(); // mmol/L
            $table->string('urine_test_result')->nullable();  // summary
            $table->string('hiv_status')->nullable();         // Positive / Negative / Unknown
            $table->string('pregnancy_test_result')->nullable();

            // Clinical notes
            $table->text('presenting_complaint')->nullable();
            $table->text('clinical_notes')->nullable();
            $table->text('diagnosis')->nullable();
            $table->text('treatment_plan')->nullable();
            $table->text('prescription')->nullable();

            // Follow-up
            $table->boolean('sick_leave')->default(false);

            $table->string('reason_for_leave')->default("");
            $table->string('sick_leave_notes')->default("");

            $table->integer('number_of_days')->default(0);
            $table->date('follow_up_date')->nullable();
            $table->text('referral_notes')->nullable();

            $table->boolean('refer_for_radiology')->default(false);
            $table->boolean('refer_for_lab')->default(false);
            $table->boolean('refer_to_specialist')->default(false);
            $table->string('specialist_name')->nullable();
            $table->boolean('refer_to_casualty')->default(false);
            $table->boolean('refer_out_patient')->default(false);

            // NEW: Restricted duty flag
            $table->boolean('restricted_duty')->default(false);

            // NEW: Hospital referred to (free text)
            $table->string('referred_hospital')->nullable();

            $table->string('blood_sugar_unit', 10)->default('mmol/L')->after('blood_sugar');
            $table->string('blood_sugar_context', 20)->nullable()->after('blood_sugar_unit');
            $table->dateTime('blood_sugar_measured_at')->nullable()->after('blood_sugar_context');

            $table->boolean('is_active')->default(true);
            $table->boolean('status')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('consultations');
    }
};
