<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('medications', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('dosage')->nullable(); // e.g. 500mg
            $table->string('form')->nullable(); // e.g. Tablet, Syrup
            $table->string('unit')->nullable(); // e.g. box, bottle
            $table->text('instructions')->nullable(); // Optional usage guidance
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('medications');
    }
};
