<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('radiology_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('consultation_id')->nullable()->constrained()->onDelete('set null');
            $table->string('radiology_type'); // e.g., "Chest X-Ray", "CT Brain"
            $table->enum('status', ['requested', 'in_progress', 'completed'])->default('requested');
            $table->text('report_notes')->nullable();                                                // Radiologist interpretation
            $table->string('result_file')->nullable();                                               // Link to PDF/image
            $table->foreignId('ordered_by')->nullable()->constrained('users')->onDelete('set null'); // doctor
            $table->foreignId('radiologist_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('radiology_orders');
    }
};
