<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_tests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('consultation_id')->nullable()->constrained()->onDelete('set null');
            $table->string('test_name'); // e.g., "FBC", "Malaria", "COVID-19 PCR"
            $table->enum('status', ['requested', 'in_progress', 'completed'])->default('requested');
            $table->text('result_value')->nullable();  // Raw result or JSON string
            $table->string('result_file')->nullable(); // If result is uploaded as PDF/image
            $table->foreignId('ordered_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('lab_technician_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_tests');
    }
};
