<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('triages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('clinic_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('nurse_id')->nullable()->constrained('users')->onDelete('set null'); // nurse or triage staffa
            $table->foreignId('consultor_id')->nullable()->constrained('users')->onDelete('set null'); // nurse who is going to see the patient first
            $table->foreignId('consultation_id')->nullable()->constrained()->onDelete('set null'); // optional link
            $table->string('triage_level')->nullable();

            $table->string('bill_type')->nullable(); // e.g., "Triage Fee", "Consultation Fee"
            $table->string('bill_class')->default('Self');
            $table->string('payment_point')->nullable()->constrained('companies')->onDelete('set null');
            $table->string('payment_method')->nullable(); // e.g., "Cash", "Insurance", "Credit Card"
            $table->text('chief_complaint')->nullable();
            $table->text('notes')->nullable();
            $table->boolean('is_active')->default(true); // to mark if the triage is still active or not

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('triages');
    }
};
