<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prescriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('consultation_id')->constrained()->onDelete('cascade');
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->unsignedBigInteger('prescribed_by')->nullable();
            $table->foreign('prescribed_by')->references('id')->on('users')->onDelete('set null');
            $table->foreignId('medication_id')->constrained()->onDelete('cascade');
            $table->string('dosage');        // e.g., "1 tablet"
            $table->string('frequency');     // e.g., "3 times a day"
            $table->string('duration');      // e.g., "5 days"
            $table->integer('quantity');     // e.g., 30 (total tablets to dispense)
            $table->string('route');         // e.g., "Oral"
            $table->string('food_relation'); // e.g., "After Food"
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prescriptions');
    }
};
