<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('central_stores', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('location')->nullable();          // e.g. "Harare HQ"
            $table->text('address')->nullable();             // Physical address
            $table->decimal('latitude', 10, 7)->nullable();  // e.g. -17.8251651
            $table->decimal('longitude', 10, 7)->nullable(); // e.g. 31.0335104
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('central_stores');
    }
};
