<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('medication_batches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('medication_id')->constrained()->cascadeOnDelete();
            $table->foreignId('central_store_id')->constrained()->cascadeOnDelete();
            $table->foreignId('supplier_id')->nullable()->constrained()->nullOnDelete();
            $table->string('batch_number')->unique();
            $table->integer('quantity');
            $table->date('expiry_date');
            $table->date('manufacture_date')->nullable();
            $table->date('received_date')->nullable();

            // New fields from form
            $table->string('invoice_number')->nullable();
            $table->decimal('price', 10, 2)->nullable();
            $table->string('invoice_file')->nullable(); // store file path

            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('medication_batches');
    }
};
