<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clinic_medication_stocks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('clinic_id')->constrained()->cascadeOnDelete();
            $table->foreignId('medication_batch_id')->constrained('medication_batches')->cascadeOnDelete();
            $table->integer('quantity')->default(0);

            // Unique constraint per clinic and batch to avoid duplicates
            $table->unique(['clinic_id', 'medication_batch_id'], 'clinic_med_stock_unique');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clinic_medication_stocks');
    }
};
