<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_transfers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('from_central_store_id')->constrained('central_stores');
            $table->foreignId('to_clinic_id')->constrained('clinics');
            $table->foreignId('medication_batch_id')->constrained('medication_batches');
            $table->integer('quantity');
            $table->date('transfer_date');
            $table->foreignId('transferred_by')->constrained('users');
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_transfers');
    }
};
