<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('logs', function (Blueprint $table) {
           $table->id();

            // User who performed the action (nullable for system actions)
            $table->unsignedBigInteger('user_id')->nullable()->index();
            $table->string('user_name')->nullable();

            // The action performed (e.g., created, updated, deleted, login, logout)
            $table->string('action')->index();

            // Polymorphic relation: which model/entity was affected
            $table->string('loggable_type')->nullable()->index();
            $table->unsignedBigInteger('loggable_id')->nullable()->index();

            // Optional descriptive message
            $table->text('description')->nullable();

            // JSON columns to keep old and new values for updates or changes
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();

            // Request metadata
            $table->ipAddress('ip_address')->nullable();
            $table->string('user_agent')->nullable();

            $table->timestamps();

            // Foreign key constraint (optional, if users table exists)
            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('logs');
    }
};
