// database/migrations/2025_09_04_000000_harden_dispensation_uniqueness.php

<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('dispensations', function (Blueprint $table) {
            // Optional: If not present yet
            if (!Schema::hasColumn('dispensations', 'nurse_medication_stock_id')) {
                $table->foreignId('nurse_medication_stock_id')->nullable()->constrained()->nullOnDelete();
            }

            // Optional idempotency key (UUID as string)
            if (!Schema::hasColumn('dispensations', 'request_id')) {
                $table->string('request_id', 36)->nullable()->unique();
            }

            // Enforce uniqueness per stock type
            $table->unique(
                ['consultation_id', 'patient_id', 'clinic_medication_stock_id'],
                'uniq_dispensation_clinic'
            );

            $table->unique(
                ['consultation_id', 'patient_id', 'nurse_medication_stock_id'],
                'uniq_dispensation_nurse'
            );
        });
    }

    public function down(): void
    {
        Schema::table('dispensations', function (Blueprint $table) {
            $table->dropUnique('uniq_dispensation_clinic');
            $table->dropUnique('uniq_dispensation_nurse');
            if (Schema::hasColumn('dispensations', 'request_id')) {
                $table->dropUnique(['request_id']);
                $table->dropColumn('request_id');
            }
            // Don't drop nurse_medication_stock_id if you’re using it elsewhere
        });
    }
};
