<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('dispensation_corrections', function (Blueprint $table) {
            $table->id();

            $table->foreignId('dispensation_id')->constrained()->cascadeOnDelete();
            $table->foreignId('consultation_id')->constrained()->cascadeOnDelete();
            $table->foreignId('patient_id')->constrained()->cascadeOnDelete();

            // From = wrong stock that must be returned
            $table->enum('from_stock_type', ['clinic', 'nurse']);
            $table->unsignedBigInteger('from_stock_id');

            // To = correct stock to dispense
            $table->enum('to_stock_type', ['clinic', 'nurse']);
            $table->unsignedBigInteger('to_stock_id');

            $table->unsignedInteger('quantity');
            $table->text('reason')->nullable();

            $table->enum('status', ['pending', 'approved', 'rejected', 'cancelled'])->default('pending');

            $table->foreignId('requested_by')->constrained('users');
            $table->timestamp('requested_at')->nullable();

            $table->foreignId('approved_by')->nullable()->constrained('users');
            $table->timestamp('approved_at')->nullable();

            $table->foreignId('rejected_by')->nullable()->constrained('users');
            $table->timestamp('rejected_at')->nullable();
            $table->text('rejection_notes')->nullable();

            // Optional idempotency / external reference
            $table->uuid('request_uuid')->nullable()->unique();

            $table->timestamps();

            // Not strict FKs for stock rows because they live in two tables
            $table->index(['from_stock_type', 'from_stock_id']);
            $table->index(['to_stock_type', 'to_stock_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('dispensation_corrections');
    }
};
