<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('medical_fund_members', function (Blueprint $table) {
            $table->id();

            $table->string('employee_number', 64)->index(); // "code"
            $table->string('first_name', 120);
            $table->string('middle_name', 120)->nullable();
            $table->string('surname', 120);

            $table->foreignId('company_id')
                  ->nullable()
                  ->constrained('companies')
                  ->nullOnDelete();

            $table->string('tag', 120)->default('Providence Fund')->index();

            $table->timestamps();

            // Avoid duplicate rows for the same person+company+tag
            $table->unique(['employee_number', 'company_id', 'tag'], 'mfm_emp_company_tag_uniq');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('medical_fund_members');
    }
};
