<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('imaging_referrals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('consultation_id')->constrained()->cascadeOnDelete();
            $table->foreignId('patient_id')->constrained()->cascadeOnDelete();
            $table->foreignId('referrer_id')->nullable()->constrained('users')->nullOnDelete(); // nurse/doctor

            // From the Baines Imaging pad
            $table->string('provider')->default('Baines Imaging Group'); // free text for future flexibility
            $table->dateTime('requested_at')->nullable();

            // Requested exams (store as JSON flags OR text)
            $table->json('exams')->nullable(); // e.g. ["ultrasound","x_rays","ct_scan","mri_scanning"]

            $table->string('region_of_interest')->nullable();
            $table->text('history')->nullable();
            $table->date('lmp')->nullable();
            $table->boolean('is_pregnant')->nullable();

            $table->string('referring_doctor_name')->nullable();
            $table->text('notes')->nullable();

            // Workflow
            $table->string('status')->default('sent'); // draft|sent|completed|cancelled

            // Optional scanned form / attachment
            $table->string('attachment_path')->nullable();

            $table->timestamps();

            $table->index(['patient_id', 'consultation_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('imaging_referrals');
    }
};
