<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_referrals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('consultation_id')->constrained()->cascadeOnDelete();
            $table->foreignId('patient_id')->constrained()->cascadeOnDelete();
            $table->foreignId('referrer_id')->nullable()->constrained('users')->nullOnDelete();

            // From the Africa Diagnostic Laboratory form
            $table->string('provider')->default('Africa Diagnostic Laboratory');
            $table->string('lab_ref_no')->nullable();
            $table->dateTime('requested_at')->nullable();

            // Clinical data & requested tests
            $table->text('clinical_data')->nullable();
            $table->json('specimen_types')->nullable();  // ["blood","urine","swab","fluid","stool","serum","other"]
            $table->text('tests_requested')->nullable(); // free text or newline list

            // Medical aid snapshot (optional)
            $table->string('medical_aid_provider')->nullable();
            $table->string('membership_no')->nullable();
            $table->string('membership_suffix')->nullable();
            $table->string('relation_to_member')->nullable();

            // Reference section (optional logistics)
            $table->string('copies_to')->nullable();
            $table->string('patient_bled_by')->nullable();
            $table->unsignedTinyInteger('tubes_edta')->default(0);
            $table->unsignedTinyInteger('tubes_sst')->default(0);
            $table->unsignedTinyInteger('tubes_plain')->default(0);
            $table->unsignedTinyInteger('tubes_fluoride')->default(0);
            $table->unsignedTinyInteger('tubes_citrate')->default(0);
            $table->unsignedTinyInteger('tubes_heparin')->default(0);

            $table->dateTime('collected_at')->nullable();
            $table->string('received_by')->nullable();
            $table->dateTime('received_at')->nullable();

            $table->text('referral_notes')->nullable();

                                                       // Workflow
            $table->string('status')->default('sent'); // draft|sent|completed|cancelled

            // Optional scanned form / attachment
            $table->string('attachment_path')->nullable();

            $table->timestamps();

            $table->index(['patient_id', 'consultation_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_referrals');
    }
};
