<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chronic_dispensations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->cascadeOnDelete();

            // Stock sources (one of these is typically used)
            $table->foreignId('clinic_medication_stock_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            $table->foreignId('nurse_medication_stock_id')
                ->nullable()
                ->constrained()
                ->nullOnDelete();

            // Who dispensed
            $table->foreignId('dispensed_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

                                                     // Core fields (same as Dispensation, minus consultation_id)
            $table->string('frequency')->nullable(); // e.g. "bd", "tds", "q8h", custom
            $table->string('route')->nullable();     // e.g. "PO", "IM", "IV"
            $table->string('duration')->nullable();  // e.g. "30 days", "3 months"
            $table->decimal('quantity', 12, 2)->default(0);
            $table->timestamp('dispensed_at')->nullable();
            $table->text('notes')->nullable();

            // Optional: tie to a chronic plan / program in future
            // $table->foreignId('chronic_program_id')->nullable()->constrained()->nullOnDelete();

            $table->timestamps();

            // Helpful indexes
            $table->index(['patient_id', 'dispensed_at']);
            $table->index(['clinic_medication_stock_id']);
            $table->index(['nurse_medication_stock_id']);
            $table->index(['dispensed_by']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chronic_dispensations');
    }
};
