<?php

namespace Database\Seeders;

use App\Models\Company;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CompanySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $companies = [
            'Bakers Inn',
            'Chicken Inn',
            'Pizza Inn',
            'Creamy Inn',
            'Steers',
            'Nando’s Zimbabwe',
            'Haefelis',
            'Simbisa Brands',
            'InnBucks',
            'Quick Serve',
            'Texas Meats',
            'National Foods',
            'Colcom Foods',
            'Irvine’s Zimbabwe',
            'Catercraft',
            'Retail Network Zimbabwe',
            'Fast Food Holdings',
            'Innscor Logistics',
            'City Bakery',
            'Fresh Bake Zimbabwe',
        ];

        foreach ($companies as $name) {
            Company::create([
                'name' => $name,
                'address' => fake()->streetAddress() . ', Harare',
                'site_telephone' => '+263 24 ' . rand(2000000, 2999999),
                'company_email' => Str::slug($name, '.') . '@innscor.co.zw',
                'contact_person' => fake()->name(),
                'province' => 'Harare',
                'designation' => fake()->jobTitle(),
                'contact_number' => '+263 77' . rand(1000000, 9999999),
            ]);
        }
    }
}
