<?php

namespace Database\Seeders;

use App\Models\Consultation;
use App\Models\DiagnosisPreset;
use App\Models\Patient;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class ConsultationSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        $patients = Patient::all();
        $clinicId = 19;

        foreach ($patients as $patient) {
            $consultations = [];

            for ($i = 0; $i < 17; $i++) {
                // Random consultation date between Jan 1, 2024 and now
                $consultationDate = $faker->dateTimeBetween('2024-01-01', 'now');

                // Use same date for created_at and updated_at
                $createdAt = $consultationDate;
                $updatedAt = $consultationDate;

                // Random diagnosis from DiagnosisPreset or null if none found
                $diagnosisPreset = DiagnosisPreset::inRandomOrder()->first();
                $diagnosis = $diagnosisPreset ? $diagnosisPreset->name : null;

                $consultations[] = [
                    'patient_id' => $patient->id,
                    'clinic_id' => $clinicId,
                    'doctor_id' => $faker->numberBetween(1, 2),
                    'consultation_date' => $consultationDate->format('Y-m-d'),

                    // Random Vitals
                    'systolic' => $faker->numberBetween(90, 140),
                    'diastolic' => $faker->numberBetween(60, 90),
                    'temperature' => $faker->randomFloat(1, 35.0, 40.0),
                    'heart_rate' => $faker->randomFloat(2, 50, 120),
                    'respiratory_rate' => $faker->randomFloat(2, 12, 25),
                    'oxygen_saturation' => $faker->randomFloat(2, 90, 100),
                    'weight' => $faker->randomFloat(2, 50, 120),
                    'height' => $faker->randomFloat(2, 140, 200),
                    'bmi' => $faker->randomFloat(2, 15, 40),

                    // Labs / Tests
                    'blood_sugar' => $faker->randomFloat(2, 3, 15),
                    'urine_test_result' => $faker->randomElement(['Normal', 'Infection detected', 'Blood present', 'Sugar present', null]),
                    'hiv_status' => $faker->randomElement(['Positive', 'Negative', 'Unknown']),
                    'pregnancy_test_result' => $faker->randomElement(['Positive', 'Negative', null]),

                    // Clinical notes
                    'presenting_complaint' => $faker->sentence(6),
                    'clinical_notes' => $faker->paragraph(),
                    'diagnosis' => $diagnosis,
                    'treatment_plan' => $faker->paragraph(),
                    'prescription' => $faker->sentence(8),

                    // Follow-up
                    'follow_up_required' => $faker->boolean(30),
                    'follow_up_date' => $faker->boolean(30) ? $faker->dateTimeBetween($consultationDate, '+1 month')->format('Y-m-d') : null,
                    'referral_notes' => $faker->optional()->sentence(),

                    'status' => $faker->boolean(80),

                    'created_at' => $createdAt,
                    'updated_at' => $updatedAt,
                ];
            }

            Consultation::insert($consultations);
        }
    }
}
