<?php
namespace Database\Seeders;

use App\Models\DiagnosisPreset;
use Illuminate\Database\Seeder;

class DiagnosisPresetSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $diagnoses = [
            ['name' => 'Hypertension', 'icd_code' => 'I10'],
            ['name' => 'Diabetes Mellitus Type 2', 'icd_code' => 'E11'],
            ['name' => 'Asthma', 'icd_code' => 'J45'],
            ['name' => 'Acute Bronchitis', 'icd_code' => 'J20'],
            ['name' => 'Chronic Obstructive Pulmonary Disease (COPD)', 'icd_code' => 'J44'],
            ['name' => 'Pneumonia', 'icd_code' => 'J18'],
            ['name' => 'Congestive Heart Failure', 'icd_code' => 'I50'],
            ['name' => 'Ischemic Heart Disease', 'icd_code' => 'I25'],
            ['name' => 'Myocardial Infarction', 'icd_code' => 'I21'],
            ['name' => 'Stroke', 'icd_code' => 'I63'],
            ['name' => 'Transient Ischemic Attack (TIA)', 'icd_code' => 'G45'],
            ['name' => 'Hyperlipidemia', 'icd_code' => 'E78.5'],
            ['name' => 'Hypothyroidism', 'icd_code' => 'E03.9'],
            ['name' => 'Hyperthyroidism', 'icd_code' => 'E05.90'],
            ['name' => 'Anemia, Iron Deficiency', 'icd_code' => 'D50'],
            ['name' => 'Anemia, Chronic Disease', 'icd_code' => 'D63.8'],
            ['name' => 'Peptic Ulcer Disease', 'icd_code' => 'K25'],
            ['name' => 'Gastritis', 'icd_code' => 'K29'],
            ['name' => 'Gastroesophageal Reflux Disease (GERD)', 'icd_code' => 'K21'],
            ['name' => 'Cholelithiasis', 'icd_code' => 'K80'],
            ['name' => 'Hepatitis B', 'icd_code' => 'B18.1'],
            ['name' => 'Hepatitis C', 'icd_code' => 'B18.2'],
            ['name' => 'Cirrhosis', 'icd_code' => 'K74.60'],
            ['name' => 'Urinary Tract Infection', 'icd_code' => 'N39.0'],
            ['name' => 'Chronic Kidney Disease', 'icd_code' => 'N18.9'],
            ['name' => 'Acute Kidney Injury', 'icd_code' => 'N17'],
            ['name' => 'Benign Prostatic Hyperplasia', 'icd_code' => 'N40'],
            ['name' => 'Prostatitis', 'icd_code' => 'N41'],
            ['name' => 'Cystitis', 'icd_code' => 'N30'],
            ['name' => 'Depression', 'icd_code' => 'F32.9'],
            ['name' => 'Anxiety Disorder', 'icd_code' => 'F41.9'],
            ['name' => 'Schizophrenia', 'icd_code' => 'F20.9'],
            ['name' => 'Bipolar Disorder', 'icd_code' => 'F31.9'],
            ['name' => 'Obsessive Compulsive Disorder', 'icd_code' => 'F42'],
            ['name' => 'Dementia', 'icd_code' => 'F03.90'],
            ['name' => 'Parkinson\'s Disease', 'icd_code' => 'G20'],
            ['name' => 'Epilepsy', 'icd_code' => 'G40.9'],
            ['name' => 'Migraine', 'icd_code' => 'G43.909'],
            ['name' => 'Tension Headache', 'icd_code' => 'G44.209'],
            ['name' => 'Osteoarthritis', 'icd_code' => 'M19.90'],
            ['name' => 'Rheumatoid Arthritis', 'icd_code' => 'M06.9'],
            ['name' => 'Gout', 'icd_code' => 'M10.9'],
            ['name' => 'Back Pain', 'icd_code' => 'M54.5'],
            ['name' => 'Sciatica', 'icd_code' => 'M54.3'],
            ['name' => 'Scoliosis', 'icd_code' => 'M41.9'],
            ['name' => 'Fracture of Femur', 'icd_code' => 'S72.9'],
            ['name' => 'Fracture of Radius', 'icd_code' => 'S52.9'],
            ['name' => 'Sprained Ankle', 'icd_code' => 'S93.4'],
            ['name' => 'Cellulitis', 'icd_code' => 'L03.90'],
            ['name' => 'Psoriasis', 'icd_code' => 'L40.9'],
            ['name' => 'Eczema', 'icd_code' => 'L30.9'],
            ['name' => 'Acne', 'icd_code' => 'L70.9'],
            ['name' => 'Otitis Media', 'icd_code' => 'H66.9'],
            ['name' => 'Tonsillitis', 'icd_code' => 'J03.9'],
            ['name' => 'Pharyngitis', 'icd_code' => 'J02.9'],
            ['name' => 'Sinusitis', 'icd_code' => 'J01.90'],
            ['name' => 'Conjunctivitis', 'icd_code' => 'H10.9'],
            ['name' => 'Glaucoma', 'icd_code' => 'H40.9'],
            ['name' => 'Cataract', 'icd_code' => 'H25.9'],
            ['name' => 'Tuberculosis', 'icd_code' => 'A15.0'],
            ['name' => 'Malaria', 'icd_code' => 'B50.9'],
            ['name' => 'HIV Infection', 'icd_code' => 'B20'],
            ['name' => 'COVID-19', 'icd_code' => 'U07.1'],
            ['name' => 'Influenza', 'icd_code' => 'J10.1'],
            ['name' => 'Chickenpox', 'icd_code' => 'B01.9'],
            ['name' => 'Measles', 'icd_code' => 'B05.9'],
            ['name' => 'Mumps', 'icd_code' => 'B26.9'],
            ['name' => 'Rubella', 'icd_code' => 'B06.9'],
            ['name' => 'Dengue Fever', 'icd_code' => 'A90'],
            ['name' => 'Zika Virus Infection', 'icd_code' => 'A92.5'],
            ['name' => 'Typhoid Fever', 'icd_code' => 'A01.0'],
            ['name' => 'Cholera', 'icd_code' => 'A00'],
            ['name' => 'Giardiasis', 'icd_code' => 'A07.1'],
            ['name' => 'Amoebiasis', 'icd_code' => 'A06.9'],
            ['name' => 'Helminthiasis', 'icd_code' => 'B83.9'],
            ['name' => 'Scabies', 'icd_code' => 'B86'],
            ['name' => 'Pediculosis', 'icd_code' => 'B85.9'],
            ['name' => 'Allergic Rhinitis', 'icd_code' => 'J30.9'],
            ['name' => 'Allergic Reaction, unspecified', 'icd_code' => 'T78.40XA'],
            ['name' => 'Anaphylaxis', 'icd_code' => 'T78.2'],
            ['name' => 'Food Poisoning', 'icd_code' => 'A05.9'],
            ['name' => 'Appendicitis', 'icd_code' => 'K35.80'],
            ['name' => 'Diverticulitis', 'icd_code' => 'K57.32'],
            ['name' => 'Pancreatitis', 'icd_code' => 'K85.9'],
            ['name' => 'Hemorrhoids', 'icd_code' => 'I84.9'],
            ['name' => 'Varicose Veins', 'icd_code' => 'I83.9'],
            ['name' => 'Deep Vein Thrombosis', 'icd_code' => 'I82.40'],
            ['name' => 'Pulmonary Embolism', 'icd_code' => 'I26.99'],
            ['name' => 'Astigmatism', 'icd_code' => 'H52.2'],
            ['name' => 'Myopia', 'icd_code' => 'H52.1'],
            ['name' => 'Hyperopia', 'icd_code' => 'H52.0'],
            ['name' => 'Otitis Externa', 'icd_code' => 'H60.3'],
            ['name' => 'Vertigo', 'icd_code' => 'R42'],
            ['name' => 'Tinnitus', 'icd_code' => 'H93.1'],
            ['name' => 'Laryngitis', 'icd_code' => 'J04.0'],
            ['name' => 'Bronchiectasis', 'icd_code' => 'J47'],
            ['name' => 'Pleural Effusion', 'icd_code' => 'J90'],
            ['name' => 'Pleurisy', 'icd_code' => 'R09.1'],
            ['name' => 'ARDS (Acute Respiratory Distress Syndrome)', 'icd_code' => 'J80'],
            ['name' => 'Sepsis', 'icd_code' => 'A41.9'],
            ['name' => 'Systemic Lupus Erythematosus', 'icd_code' => 'M32.9'],
            ['name' => 'Multiple Sclerosis', 'icd_code' => 'G35'],
            ['name' => 'Celiac Disease', 'icd_code' => 'K90.0'],
            ['name' => 'Crohn’s Disease', 'icd_code' => 'K50.90'],
            ['name' => 'Ulcerative Colitis', 'icd_code' => 'K51.90'],
            ['name' => 'Polycystic Ovary Syndrome', 'icd_code' => 'E28.2'],
            ['name' => 'Endometriosis', 'icd_code' => 'N80.9'],
            ['name' => 'Menorrhagia', 'icd_code' => 'N92.0'],
            ['name' => 'Infertility, female', 'icd_code' => 'N97.9'],
            ['name' => 'Infertility, male', 'icd_code' => 'N46.9'],
            ['name' => 'Erectile Dysfunction', 'icd_code' => 'N52.9'],
            ['name' => 'Benign Breast Lump', 'icd_code' => 'N60.29'],
            ['name' => 'Breast Cancer', 'icd_code' => 'C50.9'],
            ['name' => 'Prostate Cancer', 'icd_code' => 'C61'],
            ['name' => 'Lung Cancer', 'icd_code' => 'C34.9'],
            ['name' => 'Colon Cancer', 'icd_code' => 'C18.9'],
            ['name' => 'Leukemia', 'icd_code' => 'C91.9'],
            ['name' => 'Lymphoma', 'icd_code' => 'C85.9'],
            ['name' => 'Skin Cancer', 'icd_code' => 'C44.99'],
            ['name' => 'Thyroid Cancer', 'icd_code' => 'C73'],
        ];

        foreach ($diagnoses as $diagnosis) {
            DiagnosisPreset::create($diagnosis);
        }
    }
}
