<?php
// namespace Database\Seeders;

// use Faker\Factory as Faker;
// use Illuminate\Database\Seeder;
// use Illuminate\Support\Facades\DB;

// class MedicationSeeder extends Seeder
// {
//     /**
//      * Run the database seeds.
//      *
//      * @return void
//      */
//     public function run()
//     {
//         $faker = Faker::create();

//         $medicationNames = [
//             'Paracetamol', 'Ibuprofen', 'Amoxicillin', 'Loratadine', 'Omeprazole',
//             'Salbutamol', 'Cetirizine', 'Simvastatin', 'Metformin', 'Diazepam',
//             'Hydrocortisone', 'Fluoxetine', 'Aspirin', 'Ciprofloxacin', 'Atorvastatin',
//             'Losartan', 'Amlodipine', 'Sertraline', 'Pantoprazole', 'Levothyroxine',
//         ];

//         $forms   = ['Tablet', 'Capsule', 'Syrup', 'Injection', 'Cream', 'Ointment', 'Inhaler', 'Drops', 'Suppository'];
//         $units   = ['strip', 'bottle', 'pack', 'box', 'tube', 'inhaler', 'vial', 'sachet', 'blister pack'];
//         $dosages = ['250mg', '500mg', '100mg', '20mg', '10mg', '5mg', '1%', '2%', '50mcg', '100mcg', '200mg/5ml'];

//         $medications = [];

//         foreach ($medicationNames as $name) {
//             $form   = $faker->randomElement($forms);
//             $unit   = $faker->randomElement($units);
//             $dosage = $faker->randomElement($dosages);

//             // Adjust unit based on form for more realism
//             if ($form === 'Cream' || $form === 'Ointment') {
//                 $unit = 'tube';
//             } elseif ($form === 'Inhaler') {
//                 $unit = 'inhaler';
//             } elseif ($form === 'Injection') {
//                 $unit = 'vial';
//             } elseif ($form === 'Syrup') {
//                 $unit = 'bottle';
//             }

//             $medications[] = [
//                 'name'         => $name,
//                 'dosage'       => $dosage,
//                 'form'         => $form,
//                 'unit'         => $unit,
//                 'instructions' => $this->generateInstructions($name, $dosage, $form, $faker),
//                 'created_at'   => now(),
//                 'updated_at'   => now(),
//             ];
//         }

//         DB::table('medications')->insert($medications);
//     }

//     protected function generateInstructions($name, $dosage, $form, $faker)
//     {
//         $base = "Take as directed by your physician";

//         $specifics = [
//             'Tablet'  => [
//                 "Take {$faker->numberBetween(1, 2)} {$form}(s) every {$faker->numberBetween(4, 12)} hours",
//                 "Take {$faker->numberBetween(1, 3)} {$form}(s) daily with food",
//                 "Take {$faker->numberBetween(1, 2)} {$form}(s) at bedtime",
//             ],
//             'Capsule' => [
//                 "Swallow whole with water, do not crush or chew",
//                 "Take {$faker->numberBetween(1, 2)} {$form}(s) every {$faker->numberBetween(6, 24)} hours",
//                 "Take with a full glass of water",
//             ],
//             'Syrup'   => [
//                 "Take {$faker->numberBetween(5, 10)}ml every {$faker->numberBetween(6, 12)} hours",
//                 "Shake well before use",
//                 "Use the measuring cup provided",
//             ],
//             'Cream'   => [
//                 "Apply thin layer to affected area {$faker->numberBetween(1, 3)} times daily",
//                 "Do not apply to broken skin",
//                 "Wash hands after application",
//             ],
//             'Inhaler' => [
//                 "Use {$faker->numberBetween(1, 2)} puffs every {$faker->numberBetween(4, 12)} hours as needed",
//                 "Rinse mouth after use",
//                 "Prime before first use",
//             ],
//             'default' => [
//                 "Follow physician's instructions carefully",
//                 "Complete the full course unless otherwise directed",
//                 "Store at room temperature away from moisture",
//             ],
//         ];

//         $formSpecific = $specifics[$form] ?? $specifics['default'];
//         $instruction  = $base . ". " . $faker->randomElement($formSpecific) . ". " . $faker->randomElement([
//             "May cause drowsiness.",
//             "Take with food if stomach upset occurs.",
//             "Do not operate machinery until you know how this medication affects you.",
//             "Avoid alcohol while taking this medication.",
//             "Store in a cool, dry place.",
//             "Protect from light and moisture.",
//         ]);

//         return $instruction;
//     }
// }

namespace Database\Seeders;

use App\Models\Medication;
use Illuminate\Database\Seeder;

class MedicationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $medications = [
            // ADULT ANTIBIOTICS
            ['name' => 'AMOXYL', 'dosage' => '250', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'AMOXYL', 'dosage' => '500', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'CIPROFLOXACIN', 'dosage' => '500', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'CIPROFLOXACIN', 'dosage' => '250', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'COTRIMOXAZOLE', 'dosage' => '480', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'DOXYCYCLINE', 'dosage' => '100', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'CLOXACILLIN', 'dosage' => '250', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'CLOXACILLIN', 'dosage' => '500', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'METRONIDAZOLE', 'dosage' => '200', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'METRONIDAZOLE', 'dosage' => '400', 'form' => 'tablet', 'unit' => 'mg'],

            // ANTIFUNGAL
            ['name' => 'FLUCONAZOLE', 'dosage' => '200', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'GRESIOFULVIN', 'dosage' => '250', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'WHITFIELD OINTMENT', 'dosage' => '100', 'form' => 'ointment', 'unit' => 'ml'],

            // PAEDS SUSPENSIONS
            ['name' => 'ALLERGEX/ALLERBAN', 'dosage' => '2', 'form' => 'syrup', 'unit' => 'mg'],
            ['name' => 'COTRIMOXAZOLE', 'dosage' => '120', 'form' => 'syrup', 'unit' => 'mg'],
            ['name' => '4CS/FLUMED/FLUSTOP', 'dosage' => null, 'form' => 'syrup', 'unit' => null],
            ['name' => 'AMOXICILLIN SYRUP', 'dosage' => '125', 'form' => 'syrup', 'unit' => 'mg/5ml'],
            ['name' => 'PARACETAMOL SYRUP', 'dosage' => '125', 'form' => 'syrup', 'unit' => 'mg/5ml'],
            ['name' => 'FLUCLOXACILLIN', 'dosage' => '125', 'form' => 'syrup', 'unit' => 'mg'],
            ['name' => 'METRONIDAZOLE', 'dosage' => '125', 'form' => 'syrup', 'unit' => 'mg'],

            // OTHER SUSPENSIONS
            ['name' => 'KOSOREX/GEES/VARIFLEX', 'dosage' => '100', 'form' => 'syrup', 'unit' => 'ml'],
            ['name' => 'SOLPHYLEX', 'dosage' => null, 'form' => 'syrup', 'unit' => null],
            ['name' => 'RUBRAGEL', 'dosage' => null, 'form' => 'gel', 'unit' => null],

            // PAIN KILLERS
            ['name' => 'PARACETAMOL', 'dosage' => '500', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'IBUPROFEN', 'dosage' => '400', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'COCODAMOL', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'DICLOFENAC', 'dosage' => '50', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'INDOCID', 'dosage' => '25', 'form' => 'tablet', 'unit' => 'mg'],

            // OTHER ORAL DRUGS
            ['name' => 'ASALEN/FLUMED', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'CHLORPHERNIRAMINE', 'dosage' => '4', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'AMTRIPYALLINE', 'dosage' => '250', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'DIAZEPAM', 'dosage' => null, 'form' => 'tablet', 'unit' => null],

            // CHRONIC MEDS
            ['name' => 'PREDNISOLONE', 'dosage' => '5', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'SALBUTAMOL', 'dosage' => '4', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'NIFEDIPINE', 'dosage' => '20', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'LOSARTAN', 'dosage' => '100', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'LOSARTAN', 'dosage' => '50', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'METFORMIN', 'dosage' => '50', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'HCT', 'dosage' => '25', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'ATENOLOL', 'dosage' => '50', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'ENALAPRIL', 'dosage' => '10', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'URAZIDE', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'VENTEZE INHALER', 'dosage' => null, 'form' => 'inhaler', 'unit' => null],
            ['name' => 'BECLAMATE INHALER', 'dosage' => null, 'form' => 'inhaler', 'unit' => null],
            ['name' => 'AMLODIPINE', 'dosage' => '5', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'AMLODIPINE', 'dosage' => '10', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'GLIBECLAMIDE', 'dosage' => null, 'form' => 'tablet', 'unit' => null],

            // OTHER MEDICATIONS
            ['name' => 'MMT TAB', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'OMEPRAZOLE', 'dosage' => '20', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'ORS (SATCHETS)', 'dosage' => null, 'form' => 'powder', 'unit' => null],
            ['name' => 'VENTEZE NEB SOL', 'dosage' => null, 'form' => 'solution', 'unit' => null],
            ['name' => 'ZINC SULPHATE', 'dosage' => null, 'form' => 'tablet', 'unit' => null],

            // INJECTABLES
            ['name' => 'ATT', 'dosage' => '20', 'form' => 'injection', 'unit' => 'ml'],
            ['name' => 'CEFTRIAXONE', 'dosage' => '1', 'form' => 'injection', 'unit' => 'g'],
            ['name' => 'DIAZEPAM', 'dosage' => '10', 'form' => 'injection', 'unit' => 'mg/2ml'],
            ['name' => 'DICLOFENAC', 'dosage' => '50', 'form' => 'injection', 'unit' => 'mg'],
            ['name' => 'HYDROCORTISONE', 'dosage' => '100', 'form' => 'injection', 'unit' => 'mg'],
            ['name' => 'LIGNOCAINE', 'dosage' => '20', 'form' => 'injection', 'unit' => 'ml'],
            ['name' => 'METOCHLOPRAMIDE', 'dosage' => '10', 'form' => 'injection', 'unit' => 'mg/2ml'],
            ['name' => 'PARACETAMOL', 'dosage' => '1', 'form' => 'injection', 'unit' => 'g'],
            ['name' => '50% DEXTROSE', 'dosage' => null, 'form' => 'injection', 'unit' => null],
            ['name' => 'PROMETHAZINE', 'dosage' => '25', 'form' => 'injection', 'unit' => 'mg'],
            ['name' => 'ATROPINE', 'dosage' => null, 'form' => 'injection', 'unit' => null],
            ['name' => 'ADRENALINE', 'dosage' => '1', 'form' => 'injection', 'unit' => 'ml'],
            ['name' => 'LIGNOTOX', 'dosage' => '20', 'form' => 'injection', 'unit' => 'ml'],

            // CREAMS & TOPICALS
            ['name' => 'HYDROCORTISONE/DEVACORT', 'dosage' => null, 'form' => 'cream', 'unit' => null],
            ['name' => 'CANDID B TOPICAL LOTION', 'dosage' => null, 'form' => 'lotion', 'unit' => null],
            ['name' => 'CLOTRIMAZOLE VAG CREAM', 'dosage' => '40', 'form' => 'cream', 'unit' => 'mg'],
            ['name' => 'CLOTRIMAZOLE TOPICAL LOTION', 'dosage' => null, 'form' => 'lotion', 'unit' => null],
            ['name' => 'MICONAZOLE ORAL', 'dosage' => null, 'form' => 'gel', 'unit' => null],
            ['name' => 'ACYCLOVIR CREAM', 'dosage' => null, 'form' => 'cream', 'unit' => null],
            ['name' => 'CIPRO EYE DROPS', 'dosage' => null, 'form' => 'drops', 'unit' => null],
            ['name' => 'TEO', 'dosage' => null, 'form' => 'ointment', 'unit' => null],
            ['name' => 'EYE GENE', 'dosage' => null, 'form' => 'ointment', 'unit' => null],
            ['name' => 'HEAT RUB/FIBROSAL RUB', 'dosage' => null, 'form' => 'ointment', 'unit' => null],

            // IV FLUIDS & SOLUTIONS
            ['name' => 'EUSOL/NORMAL SALINE', 'dosage' => '1', 'form' => 'solution', 'unit' => 'l'],
            ['name' => 'R/L', 'dosage' => null, 'form' => 'solution', 'unit' => null],
            ['name' => '5% DEXTROSE', 'dosage' => null, 'form' => 'solution', 'unit' => null],

            // SPECIAL ORDER DRUGS
            ['name' => 'ACTRAPHANE', 'dosage' => '20', 'form' => 'injection', 'unit' => 'ml'],
            ['name' => 'PROPRANOLOL', 'dosage' => '40', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'HCG/PREG TESTS KIT', 'dosage' => null, 'form' => 'kit', 'unit' => null],
            ['name' => 'SURGICAL FACE MASKS', 'dosage' => null, 'form' => 'mask', 'unit' => null],
            ['name' => 'TRAMADOL INJECTION', 'dosage' => null, 'form' => 'injection', 'unit' => null],
            ['name' => 'CLINDAMYCIN', 'dosage' => '150', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'MEFENAMIC ACID', 'dosage' => '125', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'ERYTHROMYCIN', 'dosage' => '125', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'PIROXICAM', 'dosage' => '20', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'ALBENDAZOLE', 'dosage' => '200', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'TRAMADOL TABLETS', 'dosage' => '50', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'PHENOBARBITONE', 'dosage' => '30', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'ASA', 'dosage' => '300', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'VITAMIN C', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'METOCHLOPRAMIDE TABS', 'dosage' => '10', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'LOPERAMIDE', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'CELECOXIB', 'dosage' => '100', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'CETIRIZINE/LORATADINE', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'GASTROFENAC', 'dosage' => '50', 'form' => 'tablet', 'unit' => 'mg'],
            ['name' => 'DEPOMEDRO', 'dosage' => '40', 'form' => 'injection', 'unit' => 'mg'],
            ['name' => 'G&I', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'INFRA-RED THERMOMETER', 'dosage' => null, 'form' => 'device', 'unit' => null],
            ['name' => 'AZITHROMYCIN', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'VICRIL', 'dosage' => null, 'form' => 'suture', 'unit' => null],
            ['name' => 'BP MACHINE BATTERIES AAA 1.5', 'dosage' => null, 'form' => 'battery', 'unit' => null],
            ['name' => 'BP MONITOR [ELECTRIC]', 'dosage' => null, 'form' => 'device', 'unit' => null],
            ['name' => 'PULSE OXIMETER', 'dosage' => null, 'form' => 'device', 'unit' => null],
            ['name' => 'CARBAMAZEPINE', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'HALOPERIDOL', 'dosage' => null, 'form' => 'tablet', 'unit' => null],
            ['name' => 'SCALE', 'dosage' => null, 'form' => 'device', 'unit' => null],
            ['name' => 'DYNAMAP', 'dosage' => null, 'form' => 'device', 'unit' => null],
            ['name' => 'HEALTH-O-METER SCALE', 'dosage' => null, 'form' => 'device', 'unit' => null],
        ];

        foreach ($medications as $medication) {
            Medication::create([
                'name'         => $medication['name'],
                'dosage'       => $medication['dosage'],
                'form'         => $medication['form'],
                'unit'         => $medication['unit'],
                'instructions' => 'Follow the instructions provided by your healthcare provider.', // You can add default instructions if needed
            ]);
        }
    }
}
