<?php

namespace Database\Seeders;

use App\Models\Patient;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class PatientSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();
        $companyIds = \App\Models\Company::pluck('id')->toArray();
        $relationships = ['Father', 'Mother', 'Brother', 'Sister', 'Son', 'Daughter', 'Spouse', 'Uncle', 'Aunt', 'Cousin'];

        for ($i = 1; $i <= 30; $i++) {
            // Create main patient (account holder)
            $parent = Patient::create([
                'first_name' => $faker->firstName,
                'middle_name' => $faker->firstName,
                'surname' => $faker->lastName,
                'employee_number' => 'EMP' . $faker->unique()->numberBetween(1000, 9999),
                'company_id' => $faker->randomElement($companyIds),
                'parent_patient_id' => null,
                'date_of_birth' => $faker->dateTimeBetween('-60 years', '-30 years')->format('Y-m-d'),
                'email' => $faker->unique()->safeEmail,
                'gender' => $faker->randomElement(['Male', 'Female']),
                'id_number' => 'ID' . $faker->randomNumber(8, true),
                'medical_aid_number' => 'MA' . $faker->numberBetween(1000, 9999),
                'medical_aid_provider' => 'Provider ' . $faker->numberBetween(1, 3),
                'relationship' => 'Self',
                'phone' => $faker->phoneNumber,
                'emergency_contact_name' => $faker->name,
                'emergency_contact_relation' => 'Spouse',
                'emergency_contact_phone' => $faker->phoneNumber,
                'allergies' => $faker->optional()->sentence,
                'is_smoker' => $faker->boolean,
                'occupation' => $faker->jobTitle,
                'marital_status' => $faker->randomElement(['Single', 'Married', 'Divorced']),
            ]);

            // Create dependents
            $dependentsCount = rand(1, 4);
            for ($j = 1; $j <= $dependentsCount; $j++) {
                Patient::create([
                    'first_name' => $faker->firstName,
                    'middle_name' => $faker->firstName,
                    'surname' => $parent->surname, // inherit surname
                    'employee_number' => null,
                    'company_id' => null,
                    'parent_patient_id' => $parent->id,
                    'date_of_birth' => $faker->dateTimeBetween('-29 years', '-5 years')->format('Y-m-d'),
                    'email' => null,
                    'gender' => $faker->randomElement(['Male', 'Female']),
                    'id_number' => null,
                    'medical_aid_number' => null,
                    'medical_aid_provider' => null,
                    'relationship' => $faker->randomElement($relationships),
                    'phone' => null,
                    'emergency_contact_name' => null,
                    'emergency_contact_relation' => null,
                    'emergency_contact_phone' => null,
                    'allergies' => null,
                    'is_smoker' => null,
                    'occupation' => null,
                    'marital_status' => null,
                ]);
            }
        }
    }
}
