import * as React from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';

type ConsultTodayRow = {
  clinic_id: number | string;
  clinic_name: string;
  count: number;
};

type Props = {
  totalConsultedToday: number;
  consultsToday: ConsultTodayRow[];
  className?: string;
};

export default function ConsultedTodayCard({
  totalConsultedToday,
  consultsToday,
  className,
}: Props) {
  return (
    <Card className={className ?? 'sm:col-span-4'}>
      <CardHeader>
        <CardTitle>Consulted Today</CardTitle>
      </CardHeader>
      <CardContent>
        <div className="text-4xl font-bold">{totalConsultedToday}</div>

        <div className="mt-3 space-y-2">
          {consultsToday.map((c) => (
            <div
              key={c.clinic_id}
              className="flex items-center justify-between text-sm"
            >
              <Badge
                variant="outline"
                className="max-w-[70%] truncate bg-blue-50 text-blue-700 border-blue-200 dark:bg-blue-900/20 dark:text-blue-200 dark:border-blue-800"
                title={c.clinic_name}
              >
                {c.clinic_name}
              </Badge>
              <span className="font-semibold">{c.count}</span>
            </div>
          ))}

          {consultsToday.length === 0 && (
            <div className="text-sm text-muted-foreground">
              No consultations recorded today.
            </div>
          )}
        </div>
      </CardContent>
    </Card>
  );
}
