import { Card, CardHeader, CardTitle, CardContent } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";

interface PatientInfoProps {
  firstName: string;
  surname: string;
  companyName?: string;
  phoneNumber?: string;
}

export function PatientInfo({ firstName, surname, companyName, phoneNumber }: PatientInfoProps) {
  return (
    <Card className="w-full max-w-md" style={{ marginBottom: '20px' }}>
      <CardHeader>
        <CardTitle>Patient Information</CardTitle>
      </CardHeader>
      <CardContent>
        <p className="mb-2">
          <span className="font-semibold">Name: </span>
          {firstName} {surname}
        </p>
        {companyName && (
          <p className="mb-2">
            <span className="font-semibold">Company: </span>
            <Badge variant="secondary">{companyName}</Badge>
          </p>
        )}
        {phoneNumber && (
          <p>
            <span className="font-semibold">Phone: </span>
            {phoneNumber}
          </p>
        )}
      </CardContent>
    </Card>
  );
}
