import { NavMain } from '@/components/nav-main';
import { NavUser } from '@/components/nav-user';
import { NavFooter } from '@/components/nav-footer';
import {
  Sidebar, SidebarContent, SidebarFooter, SidebarHeader,
  SidebarMenu, SidebarMenuButton, SidebarMenuItem,
} from '@/components/ui/sidebar';
import { API } from '@/config';
import { type NavItem, type SharedData } from '@/types';
import { Link, router, usePage } from '@inertiajs/react';
import { LayoutGrid, User2, Shield, ArrowLeftRight } from 'lucide-react';
import AppLogo from '../app-logo';

export default function DentalSidebar() {
  const { auth, impersonation } = usePage<SharedData & { impersonation?: { active: boolean } }>().props;
  const dashboardHref = `${API}/dental`;
  const items: NavItem[] = [
    { title: 'Dashboard', href: dashboardHref, icon: LayoutGrid },
    { title: 'Database', href: `${API}/patients`, icon: User2 }, // if you have a dental-specific list, change to `${API}/dental/patients`
  ];

  const stopImpersonating = () => router.visit(route('impersonate.leave'));

  return (
    <Sidebar collapsible="icon" variant="inset">
      <SidebarHeader>
        <SidebarMenu>
          <SidebarMenuItem>
            <SidebarMenuButton size="lg" asChild>
              <Link href={dashboardHref} prefetch><AppLogo /></Link>
            </SidebarMenuButton>
          </SidebarMenuItem>
        </SidebarMenu>
      </SidebarHeader>

      <SidebarContent>
        <NavMain items={items} />
      </SidebarContent>

      <SidebarFooter>
        <div className="mb-2">
          <SidebarMenu>
            <SidebarMenuItem>
              <SidebarMenuButton asChild>
                <Link href={`${API}/kiosk`} prefetch className="w-full rounded-lg border px-3 py-2 text-sm font-medium hover:bg-accent">
                  <span className="inline-flex items-center gap-2">
                    <ArrowLeftRight className="h-4 w-4" /> Switch Module
                  </span>
                </Link>
              </SidebarMenuButton>
            </SidebarMenuItem>
          </SidebarMenu>
        </div>

        {impersonation?.active && (
          <div className="mb-2 rounded-lg border border-amber-300 bg-amber-50 px-3 py-2">
            <div className="flex items-center justify-between gap-2">
              <div className="flex items-center gap-2 text-amber-900">
                <Shield className="h-4 w-4 text-amber-600" />
                <span className="text-xs">Impersonating <strong>{auth?.user?.name ?? 'user'}</strong></span>
              </div>
              <button onClick={stopImpersonating} className="rounded bg-amber-600 px-2 py-1 text-xs font-medium text-white hover:bg-amber-700">
                Stop
              </button>
            </div>
          </div>
        )}

        {/* Dental keeps footer empty by design */}
        <NavFooter items={[]} className="mt-auto" />
        <NavUser />
      </SidebarFooter>
    </Sidebar>
  );
}
