import { usePage } from '@inertiajs/react';
import PrimarySidebar from './PrimarySidebar';
import DentalSidebar from './DentalSidebar';
import ChronicsSidebar from './ChronicsSidebar';
import MedicalsSidebar from './MedicalsSidebar';
import SecondarySidebar from './SecondarySidebar';

type ActiveModule = 'primary' | 'dental' | 'chronics' | 'secondary' | 'medicals' | null;

export default function AppSidebarRouter() {
  const { active_module } = usePage<{ active_module?: ActiveModule }>().props;
  const mod: ActiveModule = (active_module ?? 'primary') as ActiveModule;

  if (mod === 'dental')     return <DentalSidebar />;
  if (mod === 'chronics')   return <ChronicsSidebar />;
  if (mod === 'secondary')  return <SecondarySidebar />;
  if (mod === 'medicals')   return <MedicalsSidebar />;
  return <PrimarySidebar />; // default (legacy)
}
