// src/hooks/useDarkMode.ts
import { useEffect, useState } from 'react';

export function useDarkMode() {
    const [isDarkMode, setIsDarkMode] = useState(false);

    useEffect(() => {
        const userPrefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
        setIsDarkMode(userPrefersDark);
    }, []);

    return { isDarkMode };
}
