import AppLogoIcon from '@/components/app-logo-icon';
import { type SharedData } from '@/types';
import { Link, usePage } from '@inertiajs/react';
import { type PropsWithChildren } from 'react';

interface AuthLayoutProps {
    title?: string;
    description?: string;
}

export default function AuthSplitLayout({ children, title, description }: PropsWithChildren<AuthLayoutProps>) {
    const { name, quote } = usePage<SharedData>().props;

    return (
        <div className="relative grid h-dvh flex-col items-center justify-center px-8 sm:px-0 lg:max-w-none lg:grid-cols-2 lg:px-0">
            {/* Left Panel with Solid Light Green Background */}
            <div className="relative hidden h-full flex-col p-10 text-black lg:flex dark:border-r">
                {/* Background Image and Gradient Overlay */}
                <div className="absolute inset-0 z-0">
                    <img
                        src="https://providence-human-capital.github.io/images/health.png"
                        alt="Side Background"
                        className="h-full w-full object-cover"
                    />
                    <div className="absolute inset-0 bg-gradient-to-b from-black via-neutral-800 to-neutral-900 opacity-80" />
                </div>

                {/* Logo and Name */}
                <Link href={route('home')} className="relative z-20 flex items-center text-lg font-medium">
                    <AppLogoIcon className="mr-2 size-8 fill-current text-black dark:text-white" />
                    <span
                        style={{
                            color: '#fff',
                            fontWeight: "bold"
                        }}
                    >
                        {'Providence Health System'}
                    </span>
                </Link>

                {/* Quote */}
                {quote && (
                    <div className="relative z-20 mt-auto">
                        <blockquote className="space-y-2 text-white">
                            <p className="text-lg">&ldquo;{quote.message}&rdquo;</p>
                            <footer className="text-sm">{quote.author}</footer>
                        </blockquote>
                    </div>
                )}
            </div>

            {/* Right Panel - Auth Form */}
            <div className="w-full lg:p-8">
                <div className="mx-auto flex w-full flex-col justify-center space-y-6 sm:w-[350px]">
                    {/* Logo for Mobile */}
                    <Link href={route('home')} className="relative z-20 flex items-center justify-center lg:hidden">
                        <AppLogoIcon className="h-10 fill-current text-black sm:h-12" />
                    </Link>

                    {/* Title & Description */}
                    <div className="flex flex-col items-start gap-2 text-left sm:items-center sm:text-center">
                        <h1 className="text-xl font-medium">{title}</h1>
                        <p className="text-muted-foreground text-sm text-balance">{description}</p>
                    </div>

                    {/* Auth Form */}
                    {children}
                </div>
            </div>
        </div>
    );
}
