import { Head, usePage } from '@inertiajs/react';
import React from 'react';
import AppLayout from '@/layouts/app-layout';
import { Card, CardHeader, CardTitle, CardContent } from '@/components/ui/card';

export default function ChronicsDashboard() {
  const { props } = usePage<{ active_module?: string }>();
  return (
    <AppLayout breadcrumbs={[{ title: 'Chronics', href: route('chronics.dashboard') }]}>
      <Head title="Chronics Dashboard" />
      <div className="mx-auto max-w-6xl py-8">
        <h1 className="mb-6 text-2xl font-bold">Chronics Module</h1>
        <div className="grid grid-cols-1 gap-6 md:grid-cols-2">
          <Card>
            <CardHeader>
              <CardTitle>Overview</CardTitle>
            </CardHeader>
            <CardContent className="text-sm text-muted-foreground">
              Welcome to the Chronics module. Manage long-term conditions, follow ups and care plans.
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle>Quick Links</CardTitle>
            </CardHeader>
            <CardContent className="text-sm">
              <ul className="list-disc pl-5">
                <li>Patients</li>
                <li>Care Plans</li>
                <li>Follow-ups</li>
                <li>Reports</li>
              </ul>
            </CardContent>
          </Card>
        </div>
      </div>
    </AppLayout>
  );
}
