import { Head, usePage } from '@inertiajs/react';
import React from 'react';
import AppLayout from '@/layouts/app-layout';
import { Card, CardHeader, CardTitle, CardContent } from '@/components/ui/card';

export default function DentalDashboard() {
  const { props } = usePage<{ active_module?: string }>();
  return (
    <AppLayout breadcrumbs={[{ title: 'Dental', href: route('dental.dashboard') }]}>
      <Head title="Dental Dashboard" />
      <div className="mx-auto max-w-6xl py-8">
        <h1 className="mb-6 text-2xl font-bold">Dental Module</h1>
        <div className="grid grid-cols-1 gap-6 md:grid-cols-2">
          <Card>
            <CardHeader>
              <CardTitle>Overview</CardTitle>
            </CardHeader>
            <CardContent className="text-sm text-muted-foreground">
              Welcome to the Dental module. Add your dental patient flow, procedures, and reports here.
            </CardContent>
          </Card>

          <Card>
            <CardHeader>
              <CardTitle>Quick Links</CardTitle>
            </CardHeader>
            <CardContent className="text-sm">
              <ul className="list-disc pl-5">
                <li>Patients</li>
                <li>Treatment Plans</li>
                <li>Procedures</li>
                <li>Invoices</li>
              </ul>
            </CardContent>
          </Card>
        </div>
      </div>
    </AppLayout>
  );
}
