import AppLayout from '@/layouts/app-layout';
import { Head, Link, router } from '@inertiajs/react';
import React, { useState } from 'react';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { ArrowLeft, Save } from 'lucide-react';

export default function AuscultatesCreate() {
  const [name, setName] = useState('');
  const [errors, setErrors] = useState<Record<string, string[]>>({});

  const onSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    setErrors({});
    router.post(
      route('medicals.auscultates.store'),
      { name },
      {
        onError: (err) => setErrors(err as any),
      }
    );
  };

  return (
    <AppLayout breadcrumbs={[
      { title: 'Medicals', href: route('medicals.dashboard') },
      { title: 'Auscultates', href: route('medicals.auscultates.index') },
      { title: 'Create', href: route('medicals.auscultates.create') },
    ]}>
      <Head title="Create Auscultate" />

      <div className="mx-4 my-6 md:mx-8">
        <div className="mb-4 flex items-center justify-between">
          <h1 className="text-2xl font-bold">New Auscultate</h1>
          <Button asChild variant="outline">
            <Link href={route('medicals.auscultates.index')}>
              <ArrowLeft className="mr-2 h-4 w-4" /> Back
            </Link>
          </Button>
        </div>

        <Card className="">
          <CardHeader>
            <CardTitle>Details</CardTitle>
          </CardHeader>
          <CardContent>
            <form onSubmit={onSubmit} className="space-y-4">
              <div>
                <Label htmlFor="name">Name</Label>
                <Input
                  id="name"
                  value={name}
                  onChange={(e) => setName(e.target.value)}
                  placeholder="e.g. Wheeze, Crackles"
                />
                {errors?.name && (
                  <div className="mt-1 text-sm text-destructive">{errors.name[0]}</div>
                )}
              </div>

              <div className="pt-2">
                <Button type="submit" className="gap-2">
                  <Save className="h-4 w-4" />
                  Save
                </Button>
              </div>
            </form>
          </CardContent>
        </Card>
      </div>
    </AppLayout>
  );
}
