import AppLayout from '@/layouts/app-layout';
import { Head, Link, usePage } from '@inertiajs/react';
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';
import { ChevronLeft, Pencil } from 'lucide-react';

type Company = {
  id: number;
  company_name: string;
  address?: string | null;
  site_telephone?: string | null;
  company_email?: string | null;
  contact_person?: string | null;
  province?: string | null;
  designation?: string | null;
  contact_number?: string | null;
  created_at?: string | null;
  updated_at?: string | null;
};

type PageProps = { company: Company };

export default function MedicalsCompaniesShow() {
  const { company } = usePage<PageProps>().props;

  return (
    <AppLayout breadcrumbs={[
      { title: 'Medicals', href: route('medicals.dashboard') },
      { title: 'Companies', href: route('medicals.companies.index') },
      { title: company.company_name, href: '#' },
    ]}>
      <Head title={`Company • ${company.company_name}`} />

      <div className="mx-8 my-6 grid gap-6 md:grid-cols-3">
        <Card className="md:col-span-2">
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              {company.company_name}
              <Badge variant="secondary">Medicals</Badge>
            </CardTitle>
            <CardDescription>Company details</CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div>
              <h3 className="text-sm font-semibold text-muted-foreground">Address</h3>
              <p className="mt-1">{company.address ?? '—'}</p>
            </div>

            <div className="grid gap-4 sm:grid-cols-2">
              <div>
                <h3 className="text-sm font-semibold text-muted-foreground">Company Email</h3>
                <p className="mt-1">{company.company_email ?? '—'}</p>
              </div>
              <div>
                <h3 className="text-sm font-semibold text-muted-foreground">Site Telephone</h3>
                <p className="mt-1">{company.site_telephone ?? '—'}</p>
              </div>
            </div>

            <div className="grid gap-4 sm:grid-cols-3">
              <div>
                <h3 className="text-sm font-semibold text-muted-foreground">Contact Person</h3>
                <p className="mt-1">{company.contact_person ?? '—'}</p>
              </div>
              <div>
                <h3 className="text-sm font-semibold text-muted-foreground">Province</h3>
                <p className="mt-1">{company.province ?? '—'}</p>
              </div>
              <div>
                <h3 className="text-sm font-semibold text-muted-foreground">Designation</h3>
                <p className="mt-1">{company.designation ?? '—'}</p>
              </div>
            </div>

            <div>
              <h3 className="text-sm font-semibold text-muted-foreground">Contact Number</h3>
              <p className="mt-1">{company.contact_number ?? '—'}</p>
            </div>

            <div className="flex items-center gap-2 pt-2">
              <Button asChild>
                <Link href={route('medicals.companies.edit', company.id)}>
                  <Pencil className="mr-2 h-4 w-4" />
                  Edit
                </Link>
              </Button>
              <Button asChild variant="outline">
                <Link href={route('medicals.companies.index')}>
                  <ChevronLeft className="mr-2 h-4 w-4" />
                  Back
                </Link>
              </Button>
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardHeader>
            <CardTitle>Meta</CardTitle>
            <CardDescription>Timestamps for auditing</CardDescription>
          </CardHeader>
          <CardContent className="text-sm text-muted-foreground space-y-2">
            <p><span className="font-semibold">Created:</span> {company.created_at ? new Date(company.created_at).toLocaleString() : '—'}</p>
            <p><span className="font-semibold">Updated:</span> {company.updated_at ? new Date(company.updated_at).toLocaleString() : '—'}</p>
          </CardContent>
        </Card>
      </div>
    </AppLayout>
  );
}
