// resources/js/Pages/Medicals/Dashboard.tsx
import { Head, usePage } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';


export default function MedicalsDashboard() {
    const { active_module } = usePage<{ active_module?: string | null }>().props;

    return (
        <>
            <AppLayout breadcrumbs={[{ title: 'Medicals', href: route('chronics.dashboard') }]}>

                <Head title="Medicals Dashboard" />
                <div className="p-6">
                    <h1 className="text-2xl font-bold">Medicals Dashboard</h1>
                    {active_module && (
                        <p className="text-sm text-muted-foreground mt-2">
                            Active module: <span className="font-semibold uppercase">{active_module}</span>
                        </p>
                    )}
                </div>
            </AppLayout>

        </>
    );
}
