import AppLayout from '@/layouts/app-layout';
import { Head, Link, router } from '@inertiajs/react';
import React, { useState } from 'react';
import Swal from 'sweetalert2';

import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { Label } from '@/components/ui/label';
import { ArrowLeft, Save } from 'lucide-react';

export default function MedicalsDiseasesCreate() {
  const [name, setName] = useState('');
  const [errors, setErrors] = useState<{ name?: string }>({});

  const onSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    setErrors({});

    router.post(
      route('medicals.diseases.store'),
      { name },
      {
        preserveScroll: true,
        onSuccess: () => {
          Swal.fire({ icon: 'success', title: 'Disease created', timer: 1400, showConfirmButton: false });
          router.visit(route('medicals.diseases.index'));
        },
        onError: (err: any) => setErrors(err || {}),
      },
    );
  };

  return (
    <AppLayout
      breadcrumbs={[
        { title: 'Medicals', href: route('medicals.patients.index') },
        { title: 'Diseases', href: route('medicals.diseases.index') },
        { title: 'Create', href: route('medicals.diseases.create') },
      ]}
    >
      <Head title="Create Disease" />
      <div className="mx-4 my-6 md:mx-8">
        <Card className="">
          <CardHeader>
            <CardTitle>New Disease</CardTitle>
            <CardDescription>Add a new disease to the catalogue.</CardDescription>
          </CardHeader>
          <CardContent>
            <form onSubmit={onSubmit} className="space-y-6">
              <div className="grid gap-2">
                <Label htmlFor="name">Disease Name</Label>
                <Input
                  id="name"
                  value={name}
                  onChange={(e) => setName(e.target.value)}
                  placeholder="e.g., Tuberculosis"
                />
                {errors.name && <div className="text-sm text-red-600">{errors.name}</div>}
              </div>

              <div className="flex items-center justify-between">
                <Button asChild variant="outline">
                  <Link href={route('medicals.diseases.index')}>
                    <ArrowLeft className="mr-2 h-4 w-4" />
                    Back
                  </Link>
                </Button>
                <Button type="submit">
                  <Save className="mr-2 h-4 w-4" />
                  Save
                </Button>
              </div>
            </form>
          </CardContent>
        </Card>
      </div>
    </AppLayout>
  );
}
