import AppLayout from '@/layouts/app-layout';
import { Head, Link, router } from '@inertiajs/react';
import React, { useState } from 'react';
import Swal from 'sweetalert2';

import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { Label } from '@/components/ui/label';

import { ArrowLeft, Save } from 'lucide-react';

export default function MedicalsIllnessesCreate() {
  const [illnessName, setIllnessName] = useState('');
  const [errors, setErrors] = useState<{ illness_name?: string }>({});

  const onSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    setErrors({});

    router.post(
      route('medicals.illnesses.store'),
      { illness_name: illnessName },
      {
        preserveScroll: true,
        onSuccess: () => {
          Swal.fire({ icon: 'success', title: 'Illness created', timer: 1400, showConfirmButton: false });
          router.visit(route('medicals.illnesses.index'));
        },
        onError: (err: any) => {
          setErrors(err || {});
        },
      },
    );
  };

  return (
    <AppLayout
      breadcrumbs={[
        { title: 'Medicals', href: route('medicals.patients.index') },
        { title: 'Illnesses', href: route('medicals.illnesses.index') },
        { title: 'Create', href: route('medicals.illnesses.create') },
      ]}
    >
      <Head title="Create Illness" />

      <div className="mx-4 my-6 md:mx-8">
        {/* This is the only line that changed */}
        <Card>
          <CardHeader>
            <CardTitle>New Illness</CardTitle>
            <CardDescription>Add a new illness to the catalogue.</CardDescription>
          </CardHeader>
          <CardContent>
            <form onSubmit={onSubmit} className="space-y-6">
              <div className="grid gap-2">
                <Label htmlFor="illness_name">Illness Name</Label>
                <Input
                  id="illness_name"
                  value={illnessName}
                  onChange={(e) => setIllnessName(e.target.value)}
                  placeholder="e.g., Hypertension"
                />
                {errors.illness_name && (
                  <div className="text-sm text-red-600">{errors.illness_name}</div>
                )}
              </div>

              <div className="flex items-center justify-between">
                <Button asChild variant="outline">
                  <Link href={route('medicals.illnesses.index')}>
                    <ArrowLeft className="mr-2 h-4 w-4" />
                    Back
                  </Link>
                </Button>

                <Button type="submit">
                  <Save className="mr-2 h-4 w-4" />
                  Save
                </Button>
              </div>
            </form>
          </CardContent>
        </Card>
      </div>
    </AppLayout>
  );
}