import AppLayout from '@/layouts/app-layout';
import { Head, Link, router } from '@inertiajs/react';
import React, { useState } from 'react';
import { Card, CardHeader, CardTitle, CardContent } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { ArrowLeft, Save } from 'lucide-react';

export default function SkinConditionsCreate() {
  const [name, setName] = useState('');
  const [errors, setErrors] = useState<Record<string, string[]>>({});

  const submit = () => {
    setErrors({});
    router.post(
      route('medicals.skin-conditions.store'),
      { name },
      {
        onError: (e) => setErrors(e as any),
      }
    );
  };

  return (
    <AppLayout breadcrumbs={[
      { title: 'Medicals', href: route('medicals.dashboard') },
      { title: 'Skin Conditions', href: route('medicals.skin-conditions.index') },
      { title: 'Create', href: route('medicals.skin-conditions.create') },
    ]}>
      <Head title="Create Skin Condition" />

      <div className="mx-4 my-6 md:mx-8">
        <Card className="">
          <CardHeader>
            <CardTitle>New Skin Condition</CardTitle>
          </CardHeader>
          <CardContent className="space-y-4">
            <div>
              <Label htmlFor="name">Name</Label>
              <Input id="name" value={name} onChange={(e)=>setName(e.target.value)} placeholder="e.g. Dermatitis" />
              {errors?.name && <p className="mt-1 text-sm text-red-600">{errors.name[0]}</p>}
            </div>

            <div className="flex justify-between">
              <Button asChild variant="outline">
                <Link href={route('medicals.skin-conditions.index')}>
                  <ArrowLeft className="mr-2 h-4 w-4" />
                  Back
                </Link>
              </Button>

              <Button onClick={submit}>
                <Save className="mr-2 h-4 w-4" />
                Save
              </Button>
            </div>
          </CardContent>
        </Card>
      </div>
    </AppLayout>
  );
}
