import AppLayout from '@/layouts/app-layout';
import { Head, Link, router, usePage } from '@inertiajs/react';
import React, { useState } from 'react';
import { Card, CardHeader, CardTitle, CardContent } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { ArrowLeft, Save, Trash2 } from 'lucide-react';

type PageProps = {
  condition: {
    id: number;
    name: string;
  }
}

export default function SkinConditionsEdit() {
  const { condition } = usePage<PageProps>().props;
  const [name, setName] = useState(condition.name);
  const [errors, setErrors] = useState<Record<string, string[]>>({});

  const save = () => {
    setErrors({});
    router.patch(
      route('medicals.skin-conditions.update', condition.id),
      { name },
      { onError: (e)=> setErrors(e as any) }
    );
  };

  const destroy = () => {
    router.delete(route('medicals.skin-conditions.destroy', condition.id));
  };

  return (
    <AppLayout breadcrumbs={[
      { title: 'Medicals', href: route('medicals.dashboard') },
      { title: 'Skin Conditions', href: route('medicals.skin-conditions.index') },
      { title: `Edit #${condition.id}`, href: route('medicals.skin-conditions.edit', condition.id) },
    ]}>
      <Head title={`Edit Skin Condition #${condition.id}`} />

      <div className="mx-4 my-6 md:mx-8">
        <Card className="">
          <CardHeader>
            <CardTitle>Edit Skin Condition</CardTitle>
          </CardHeader>
          <CardContent className="space-y-4">
            <div>
              <Label htmlFor="name">Name</Label>
              <Input id="name" value={name} onChange={(e)=>setName(e.target.value)} />
              {errors?.name && <p className="mt-1 text-sm text-red-600">{errors.name[0]}</p>}
            </div>

            <div className="flex justify-between">
              <Button asChild variant="outline">
                <Link href={route('medicals.skin-conditions.index')}>
                  <ArrowLeft className="mr-2 h-4 w-4" />
                  Back
                </Link>
              </Button>

              <div className="flex gap-2">
                <Button variant="destructive" onClick={destroy}>
                  <Trash2 className="mr-2 h-4 w-4" />
                  Delete
                </Button>
                <Button onClick={save}>
                  <Save className="mr-2 h-4 w-4" />
                  Save
                </Button>
              </div>
            </div>
          </CardContent>
        </Card>
      </div>
    </AppLayout>
  );
}
