import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
// import { Textarea } from '@/components/ui/textarea';
import AppLayout from '@/layouts/app-layout';
import { BreadcrumbItem } from '@/types';
import { Head, useForm, usePage } from '@inertiajs/react';

export default function MedicationEdit() {
    const { medication } = usePage<{ medication: any }>().props;

    const { data, setData, put, errors, processing } = useForm({
        name: medication.name,
        dosage: medication.dosage || '',
        form: medication.form || '',
        unit: medication.unit || '',
        instructions: medication.instructions || '',
    });

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        put(route('medications.update', medication.id));
    };

    const breadcrumbs: BreadcrumbItem[] = [
        { title: 'Medications', href: route('medications.index') },
        { title: medication.name, href: route('medications.show', medication.id) },
        { title: 'Edit', href: route('medications.edit', medication.id) },
    ];

    const medicationForms = ['Tablet', 'Capsule', 'Syrup', 'Injection', 'Cream', 'Ointment', 'Inhaler', 'Drops', 'Suppository'];

    const medicationUnits = ['strip', 'bottle', 'pack', 'box', 'tube', 'inhaler', 'vial', 'sachet', 'blister pack'];

    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <Head title={`Edit ${medication.name}`} />
            <div className="w-full px-4 py-6 sm:px-6">
                <form onSubmit={handleSubmit} className="space-y-8">
                    <div className="bg-card rounded-lg border p-6 shadow-sm">
                        <h2 className="mb-4 text-xl font-semibold">Basic Information</h2>
                        <div className="grid grid-cols-1 gap-6 md:grid-cols-2">
                            <div className="space-y-2">
                                <Label htmlFor="name">Medication Name*</Label>
                                <Input
                                    id="name"
                                    value={data.name}
                                    onChange={(e) => setData('name', e.target.value)}
                                    placeholder="e.g. Paracetamol"
                                    required
                                />
                                {errors.name && <p className="text-sm text-red-500">{errors.name}</p>}
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="dosage">Dosage</Label>
                                <Input id="dosage" value={data.dosage} onChange={(e) => setData('dosage', e.target.value)} placeholder="e.g. 500mg" />
                                {errors.dosage && <p className="text-sm text-red-500">{errors.dosage}</p>}
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="form">Form</Label>
                                <select
                                    id="form"
                                    value={data.form}
                                    onChange={(e) => setData('form', e.target.value)}
                                    className="w-full rounded-md border border-gray-300 bg-white px-3 py-2 text-sm text-gray-900 shadow-sm focus:border-blue-500 focus:ring-1 focus:ring-blue-500 focus:outline-none dark:border-gray-700 dark:bg-black dark:text-white"
                                >
                                    <option value="">Select form</option>
                                    {medicationForms.map((form) => (
                                        <option key={form} value={form}>
                                            {form}
                                        </option>
                                    ))}
                                </select>
                                {errors.form && <p className="text-sm text-red-500">{errors.form}</p>}
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="unit">Unit</Label>
                                <select
                                    id="unit"
                                    value={data.unit}
                                    onChange={(e) => setData('unit', e.target.value)}
                                    className="w-full rounded-md border border-gray-300 bg-white px-3 py-2 text-sm text-gray-900 shadow-sm focus:border-blue-500 focus:ring-1 focus:ring-blue-500 focus:outline-none dark:border-gray-700 dark:bg-black dark:text-white"
                                >
                                    <option value="">Select unit</option>
                                    {medicationUnits.map((unit) => (
                                        <option key={unit} value={unit}>
                                            {unit}
                                        </option>
                                    ))}
                                </select>
                                {errors.unit && <p className="text-sm text-red-500">{errors.unit}</p>}
                            </div>
                        </div>
                    </div>

                    <div className="bg-card rounded-lg border p-6 shadow-sm">
                        <h2 className="mb-4 text-xl font-semibold">Usage Instructions</h2>
                        <div className="space-y-2">
                            <Label htmlFor="instructions">Instructions</Label>
                            <textarea
                                id="instructions"
                                value={data.instructions}
                                onChange={(e) => setData('instructions', e.target.value)}
                                placeholder="e.g. Take 1 tablet every 4-6 hours as needed for pain or fever"
                                rows={4}
                                className="w-full rounded-md border border-gray-300 bg-white px-3 py-2 text-sm text-gray-900 shadow-sm focus:border-blue-500 focus:ring-1 focus:ring-blue-500 focus:outline-none dark:border-gray-700 dark:bg-black dark:text-white"
                            />
                            {errors.instructions && <p className="text-sm text-red-500">{errors.instructions}</p>}
                        </div>
                    </div>

                    <div className="flex justify-end gap-4">
                        <Button type="button" variant="outline" onClick={() => window.history.back()}>
                            Cancel
                        </Button>
                        <Button type="submit" disabled={processing}>
                            {processing ? 'Updating...' : 'Update Medication'}
                        </Button>
                    </div>
                </form>
            </div>
        </AppLayout>
    );
}
