import { LucideIcon } from 'lucide-react';
import type { Config } from 'ziggy-js';

export interface Auth {
    user: User;
}

export interface BreadcrumbItem {
    title: string;
    href: string;
}

export interface NavGroup {
    title: string;
    items: NavItem[];
}

export interface NavItem {
    title: string;
    href: string;
    icon?: LucideIcon | null;
    isActive?: boolean;
}

export interface SharedData {
    name: string;
    quote: { message: string; author: string };
    auth: Auth;
    ziggy: Config & { location: string };
    sidebarOpen: boolean;
    [key: string]: unknown;
}

export interface User {
    id: number;
    name: string;
    email: string;
    avatar?: string;
    email_verified_at: string | null;
    created_at: string;
    updated_at: string;
    [key: string]: unknown; // This allows for additional properties...
}


interface MedicationRequest {
    id: number;
    clinic_id: number;
    medication: {
        id: number;
        name: string;
        dosage: string;
        form: string;
        unit: string;
        instructions: string;
    };
    quantity: number;
    request_date: string;
    status: string;
}


export interface MedicationRequestAll {
    id: number;
    clinic_id: number;
    clinic: {
        id: number;
        name: string;
    };
    medication: {
        id: number;
        name: string;
        dosage: string;
        form: string;
        unit: string;
        instructions: string;
    };
    quantity: number;
    transferred_quantity: number;
    request_date: string;
    status: string;
}

export interface Clinic {
    id: number,
    name: string,
    address: string,
}

export interface PagePropsWithMedicationRequestsAll extends PageProps {
    requests: {
        data: MedicationRequestAll[];
        total: number;
        per_page: number;
        current_page: number;
        last_page: number;
    };
    clinics: Clinic;
    filters: {
        search?: string;
    };
    [key: string]: any; // Add this index signature
}

interface PagePropsWithMedicationRequests extends PageProps {
    clinic: {
        id: number;
        name: string;
        city: string;
        manager: string;
        contact_person: string;
        email_address: string;
    };
    requests: {
        data: MedicationRequest[];
        total: number;
        per_page: number;
        current_page: number;
        last_page: number;
    };
    filters: {
        search?: string;
    };
    [key: string]: any; // Add this index signature
}