import { PageProps as InertiaPageProps } from '@inertiajs/core';

export interface Medication {
    id: number;
    name: string;
    dosage: string | null;
    form: string | null;
    unit: string | null;
    instructions: string | null;
}

interface MedicationBatch {
    id: number;
    medication_id: number;
    central_store_id: number;
    supplier_id: number;
    batch_number: string;
    quantity: number;
    expiry_date: string;
    manufacture_date: string;
    received_date: string;
    created_at: string;
    updated_at: string;
    medication: Medication;
}

export interface ClinicMedicationStock {
    id: number;
    quantity: number;
    expiry_date: string | null;
    batch_number: string | null;
    medication: Medication;
    medication_batch: MedicationBatch;
}

export interface Patient {
    id: number;
    name: string;
    first_name: string;
    surname: string;
    employee_number: string | null;
}

export interface Consultation {
    id: number;
    clinic_id: number;
    patient: Patient;
    consultation_date: string;
    presenting_complaint?: string;
    diagnosis?: string;
    doctor?: {
        name: string;
    };
    clinic?: {
        name: string;
        address: string;
        contact_person: string;
        email_address: string;
    };
}
export interface Dispensation {
    id: number;
    quantity: number;
    dispensed_at: string;
    clinic_medication_stock: {
        id: number;
        medication: Medication;
    };
}

export interface Clinic {
    id: number;
    name: string;
}

export interface PaginatedStocks extends InertiaPageProps {
    data: ClinicMedicationStock[];
    current_page: number;
    last_page: number;
    per_page: number;
    total: number;
}
