// resources/js/utils/authz.ts
export type AbilityMap = Record<string, boolean>;

export type AuthUser = {
  id: number;
  name: string;
  role?: string;         // single role string (optional)
  roles?: string[];      // multiple roles (optional)
  can?: AbilityMap;      // e.g. { delete_consultations: true }
};

export const hasRole = (user?: AuthUser | null, role?: string) =>
  !!user && !!role && (user.role === role || user.roles?.includes(role));

export const hasAnyRole = (user?: AuthUser | null, roles: string[] = []) =>
  !!user && roles.some(r => hasRole(user, r));

export const can = (user?: AuthUser | null, ability?: string) =>
  !!user && !!ability && !!user.can?.[ability];

export const isSuperAdmin = (user?: AuthUser | null) =>
  hasRole(user, 'superadmin');

export const canDeleteConsultation = (user?: AuthUser | null) =>
  isSuperAdmin(user) || can(user, 'delete_consultations');
