<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta charset="utf-8">
  <title>Daily Dispensations</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!--[if !mso]><!-->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <!--<![endif]-->
  <style type="text/css">
    /* General client resets */
    body, table, td, a { text-size-adjust:100%; -ms-text-size-adjust:100%; -webkit-text-size-adjust:100%; }
    table, td { mso-table-lspace:0pt; mso-table-rspace:0pt; }
    img { -ms-interpolation-mode:bicubic; border:0; outline:none; text-decoration:none; display:block; }
    body { margin:0; padding:0; width:100% !important; height:100% !important; }
    table { border-collapse:collapse !important; }
    /* Responsive container */
    @media screen and (max-width: 640px) {
      .container { width:100% !important; max-width:100% !important; }
      .p-24 { padding:16px !important; }
      .h1 { font-size:22px !important; line-height:28px !important; }
      .mb-16 { margin-bottom:12px !important; }
    }
    /* Dark mode-ish support (some clients honor) */
    @media (prefers-color-scheme: dark) {
      body { background:#0b0b0b !important; color:#f1f5f9 !important; }
      .card { background:#111827 !important; border-color:#1f2937 !important; }
      .muted { color:#9ca3af !important; }
      .divider { border-color:#1f2937 !important; }
      .button { background:#2563eb !important; color:#ffffff !important; }
    }
  </style>
</head>

<body style="background:#f3f4f6; margin:0; padding:0;">
  <!-- Preheader (hidden preview text) -->
  <div style="display:none; max-height:0; overflow:hidden; mso-hide:all;">
    Daily Dispensations for {{ $forDate->isoFormat('dddd, D MMMM YYYY') }}. The Excel report is attached.
  </div>

  <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0" style="background:#f3f4f6;">
    <tr>
      <td align="center" style="padding:24px;">
        <table role="presentation" width="600" cellpadding="0" cellspacing="0" border="0" class="container" style="width:600px; max-width:600px;">
          <!-- Header -->
          <tr>
            <td align="left" style="padding:24px 12px 8px 12px;">
              <table role="presentation" width="100%">
                <tr>
                  <td align="left" style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#6b7280;">
                    {{ config('app.name') }}
                  </td>
                  <td align="right" style="font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#6b7280;">
                    {{ now()->format('Y-m-d H:i') }}
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Card -->
          <tr>
            <td class="p-24" style="padding:24px;">
              <table role="presentation" width="100%" class="card" style="background:#ffffff; border:1px solid #e5e7eb; border-radius:8px; overflow:hidden;">
                <!-- Title -->
                <tr>
                  <td style="padding:24px 24px 8px 24px;">
                    <h1 class="h1" style="margin:0; font-family:Arial, Helvetica, sans-serif; font-size:24px; line-height:32px; color:#111827;">
                      Daily Dispensations
                    </h1>
                    <p class="mb-16" style="margin:8px 0 0 0; font-family:Arial, Helvetica, sans-serif; font-size:14px; line-height:20px; color:#6b7280;">
                      Date: <strong style="color:#111827;">{{ $forDate->isoFormat('dddd, D MMMM YYYY') }}</strong>
                    </p>
                  </td>
                </tr>

                <!-- Filters (optional) -->
                @if(!empty($filtersLine))
                <tr>
                  <td style="padding:0 24px 16px 24px;">
                    <table role="presentation" width="100%" style="background:#f9fafb; border:1px solid #e5e7eb; border-radius:6px;">
                      <tr>
                        <td style="padding:12px 16px;">
                          <p style="margin:0; font-family:Arial, Helvetica, sans-serif; font-size:13px; line-height:18px; color:#374151;">
                            <strong style="color:#111827;">Filters:</strong> {{ $filtersLine }}
                          </p>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
                @endif

                <!-- Body copy -->
                <tr>
                  <td style="padding:8px 24px 8px 24px;">
                    <p style="margin:0 0 12px 0; font-family:Arial, Helvetica, sans-serif; font-size:14px; line-height:22px; color:#374151;">
                      Please find the Excel report attached to this email. It includes all dispensed medications captured for the date above, with relevant details such as patient, medication, quantities, clinic, diagnosis, and sick-leave indicators.
                    </p>
                    <p class="muted" style="margin:0; font-family:Arial, Helvetica, sans-serif; font-size:12px; line-height:18px; color:#6b7280;">
                      If you have trouble opening the attachment, reply to this message and we’ll resend it in an alternate format.
                    </p>
                  </td>
                </tr>

                <!-- Divider -->
                <tr>
                  <td class="divider" style="padding:16px 24px 0 24px; border-top:1px solid #e5e7eb;"></td>
                </tr>

                <!-- Footer -->
                <tr>
                  <td style="padding:16px 24px 24px 24px;">
                    <p style="margin:0 0 4px 0; font-family:Arial, Helvetica, sans-serif; font-size:13px; line-height:20px; color:#374151;">
                      Regards,<br>
                      {{ config('app.name') }}
                    </p>
                    <p class="muted" style="margin:8px 0 0 0; font-family:Arial, Helvetica, sans-serif; font-size:12px; line-height:18px; color:#6b7280;">
                      This is an automated message. Do not reply if not required.
                    </p>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Legal / smallprint -->
          <tr>
            <td align="center" style="padding:0 24px 32px 24px;">
              <p class="muted" style="margin:0; font-family:Arial, Helvetica, sans-serif; font-size:11px; line-height:16px; color:#9ca3af;">
                © {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
              </p>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>

</body>
</html>
