<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta charset="utf-8">
  <title>Daily Nurse Consultations</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!--[if !mso]><!-->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <!--<![endif]-->
  <style type="text/css">
    /* Resets & email client quirks */
    body, table, td, a { -ms-text-size-adjust:100%; -webkit-text-size-adjust:100%; text-size-adjust:100%; }
    table, td { mso-table-lspace:0pt; mso-table-rspace:0pt; }
    img { -ms-interpolation-mode:bicubic; border:0; outline:none; text-decoration:none; display:block; }
    body { margin:0; padding:0; width:100% !important; height:100% !important; background:#f3f4f6; }
    table { border-collapse:collapse !important; }
    a { color:inherit; text-decoration:none; }
    /* Utilities */
    .container { width:600px; max-width:600px; }
    .card { background:#ffffff; border:1px solid #e5e7eb; border-radius:8px; overflow:hidden; }
    .muted { color:#6b7280; }
    .pill { display:inline-block; padding:4px 10px; border-radius:999px; font-size:12px; line-height:16px; background:#eef2ff; color:#3730a3; }
    .divider { border-top:1px solid #e5e7eb; }
    .li { margin:0 0 8px 0; }
    .kbd { display:inline-block; padding:2px 6px; font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; font-size:12px; border:1px solid #e5e7eb; border-radius:4px; background:#f9fafb; }
    /* Responsive */
    @media screen and (max-width: 640px) {
      .container { width:100% !important; max-width:100% !important; }
      .p24 { padding:16px !important; }
      .h1 { font-size:20px !important; line-height:26px !important; }
    }
    /* Gentle dark mode */
    @media (prefers-color-scheme: dark) {
      body { background:#0b0b0b !important; color:#f3f4f6 !important; }
      .card { background:#111827 !important; border-color:#1f2937 !important; }
      .muted { color:#9ca3af !important; }
      .divider { border-color:#1f2937 !important; }
      .pill { background:#1e293b !important; color:#c7d2fe !important; }
      .kbd { background:#0b1220 !important; border-color:#1f2937 !important; }
    }
  </style>
</head>
<body>
  <!-- Preheader (hidden preview text) -->
  <div style="display:none;max-height:0;overflow:hidden;mso-hide:all;">
    Per-nurse consultations for {{ $forDate->isoFormat('dddd, D MMMM YYYY') }} with patient and consultation details, plus per-sheet summaries. The Excel workbook is attached.
  </div>

  <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0">
    <tr>
      <td align="center" style="padding:24px;">
        <table role="presentation" class="container" cellpadding="0" cellspacing="0" border="0">
          <!-- Header meta -->
          <tr>
            <td align="left" style="padding:8px 4px 12px 4px;">
              <table role="presentation" width="100%">
                <tr>
                  <td style="font:12px/18px Arial,Helvetica,sans-serif;" class="muted">
                    {{ config('app.name') }}
                  </td>
                  <td align="right" style="font:12px/18px Arial,Helvetica,sans-serif;" class="muted">
                    Generated: {{ now()->format('Y-m-d H:i') }} • Africa/Harare
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Card -->
          <tr>
            <td class="p24" style="padding:24px;">
              <table role="presentation" width="100%" class="card" cellpadding="0" cellspacing="0" border="0">
                <tr>
                  <td style="padding:24px 24px 8px 24px;">
                    <div class="pill">Daily Nurse Consultations</div>
                    <h1 class="h1" style="margin:10px 0 6px 0;font:24px/32px Arial,Helvetica,sans-serif;color:#111827;">
                      Report for {{ $forDate->isoFormat('dddd, D MMMM YYYY') }}
                    </h1>
                    @if(!empty($filtersLine))
                      <p style="margin:0;font:13px/20px Arial,Helvetica,sans-serif;" class="muted">
                        <strong style="color:#111827;">Filters:</strong> {{ $filtersLine }}
                      </p>
                    @endif
                  </td>
                </tr>

                <tr><td class="divider" style="padding:0 24px; border-top:1px solid #e5e7eb;"></td></tr>

                <!-- What this email is about -->
                <tr>
                  <td style="padding:16px 24px 4px 24px;">
                    <p style="margin:0 0 10px 0; font:14px/22px Arial,Helvetica,sans-serif; color:#374151;">
                      Attached is an Excel workbook containing all <strong>consultations performed today by each nurse</strong>. It helps clinical leads and HR review activity and quickly surface trends (sick leave, referrals, IODs) at the end of each day.
                    </p>
                  </td>
                </tr>

                <!-- What's inside -->
                <tr>
                  <td style="padding:0 24px 8px 24px;">
                    <table role="presentation" width="100%" style="background:#f9fafb;border:1px solid #e5e7eb;border-radius:8px;">
                      <tr>
                        <td style="padding:16px;">
                          <p style="margin:0 0 6px 0; font:13px/20px Arial,Helvetica,sans-serif; color:#111827;"><strong>What’s inside the workbook</strong></p>
                          <ul style="padding:0 0 0 18px; margin:8px 0 0 0; font:13px/20px Arial,Helvetica,sans-serif; color:#374151;">
                            <li class="li"><strong>One sheet per nurse</strong> listing all consultations performed on the report date.</li>
                            <li class="li"><strong>Patient details:</strong> First, Middle, Surname, Gender, Phone, Employee Number, Company, Dependent flag; if dependent: <em>Account Holder</em> full name and employee number.</li>
                            <li class="li"><strong>Consultation details:</strong> Clinic, Diagnosis, Sick Leave (✓) with days & reasons, IOD flag, Referral flags (Radiology, Lab, Specialist, Casualty, Out-Patient), Specialist name, Referral notes.</li>
                            <li class="li"><strong>Per-sheet summary</strong> at the bottom: Total consultations, Sick-leave count & total days, IOD count, and counts for each referral type.</li>
                          </ul>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>

                <!-- Data window -->
                <tr>
                  <td style="padding:8px 24px 8px 24px;">
                    <p style="margin:0; font:13px/20px Arial,Helvetica,sans-serif; color:#374151;">
                      <strong>Data window:</strong> All consultations recorded on <strong>{{ $forDate->isoFormat('dddd, D MMMM YYYY') }}</strong>.
                    </p>
                  </td>
                </tr>

                <!-- How sheets are organized -->
                <tr>
                  <td style="padding:8px 24px 8px 24px;">
                    <p style="margin:0 0 6px 0; font:13px/20px Arial,Helvetica,sans-serif; color:#111827;"><strong>How sheets are organized</strong></p>
                    <p style="margin:0; font:13px/20px Arial,Helvetica,sans-serif; color:#374151;">
                      Each worksheet is titled with the nurse’s name. Use Excel’s sheet tabs or press <span class="kbd">Ctrl</span>+<span class="kbd">PgDn</span>/<span class="kbd">PgUp</span> to switch between nurses.
                    </p>
                  </td>
                </tr>

                <!-- Help / contact -->
                <tr>
                  <td style="padding:16px 24px 20px 24px;">
                    <p style="margin:0; font:13px/20px Arial,Helvetica,sans-serif;" class="muted">
                      Trouble opening the attachment or need a different format? Reply to this email and the IT team will assist.
                    </p>
                  </td>
                </tr>

                <tr><td class="divider" style="padding:0 24px; border-top:1px solid #e5e7eb;"></td></tr>

                <!-- Footer -->
                <tr>
                  <td style="padding:16px 24px 24px 24px;">
                    <p style="margin:0 0 4px 0; font:13px/20px Arial,Helvetica,sans-serif; color:#374151;">
                      Regards,<br>{{ config('app.name') }}
                    </p>
                    <p style="margin:8px 0 0 0; font:11px/16px Arial,Helvetica,sans-serif;" class="muted">
                      This is an automated daily report sent at 17:30 (Africa/Harare).
                    </p>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Legal -->
          <tr>
            <td align="center" style="padding:0 24px 32px 24px;">
              <p class="muted" style="margin:0; font:11px/16px Arial,Helvetica,sans-serif;">
                © {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
              </p>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</body>
</html>
