<?php

use App\Http\Controllers\External\PatientLookupController;
use App\Http\Middleware\CheckApiKey;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::prefix('api/external/v1')->middleware([CheckApiKey::class])->group(function () {
    // GET /api/external/v1/patients/lookup?employee_number=E123 OR ?id_number=63-123456A12
    Route::get('/patients/lookup', [PatientLookupController::class, 'lookup']);

});

Route::get('/patients', [PatientLookupController::class, 'list']);
