<?php

use App\Http\Controllers\BulkUploadController;
use App\Http\Controllers\CentralStoreController;
use App\Http\Controllers\CentralStoreReportsController;
use App\Http\Controllers\Chronics\ChronicDispensationController;
use App\Http\Controllers\Chronics\ChronicsDashboardController;
use App\Http\Controllers\Chronics\ChronicsPatientsController;
use App\Http\Controllers\ClinicAccessController;
use App\Http\Controllers\ClinicController;
use App\Http\Controllers\ClinicMedicationStockController;
use App\Http\Controllers\ClinicReportsController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ConsultationController;
use App\Http\Controllers\DashboardReportsController;
use App\Http\Controllers\Dental\DentalDashboardController;
use App\Http\Controllers\DiagnosisPresetController;
use App\Http\Controllers\DiagnosisReportController;
use App\Http\Controllers\DispensationController;
use App\Http\Controllers\DispensationCorrectionController;
use App\Http\Controllers\DoctorNoteController;
use App\Http\Controllers\DuplicatePatientController;
use App\Http\Controllers\EmployeeReportsController;
use App\Http\Controllers\FileReportController;
use App\Http\Controllers\ImagingReferralController;
use App\Http\Controllers\KioskController;
use App\Http\Controllers\LabReferralController;
use App\Http\Controllers\LabTestController;
use App\Http\Controllers\LogController;
use App\Http\Controllers\MedicalFundMemberController;
use App\Http\Controllers\Medicals\AttendeeController as MedicalsAttendeeController;
use App\Http\Controllers\Medicals\DiseaseController;
use App\Http\Controllers\Medicals\IllnessController;
use App\Http\Controllers\Medicals\MedicalsDashboardController;
use App\Http\Controllers\Medicals\SkinConditionController;
use App\Http\Controllers\MedicationController;
use App\Http\Controllers\MedicationRequestController;
use App\Http\Controllers\MonthlyAilmentsController;
use App\Http\Controllers\MonthlyAttendanceReportController;
use App\Http\Controllers\MonthlyDispenseReportController;
use App\Http\Controllers\NurseDashboardReportsController;
use App\Http\Controllers\NurseMedicationStockController;
use App\Http\Controllers\NurseReportsController;
use App\Http\Controllers\PatientController;
use App\Http\Controllers\PayrollReportsController;
use App\Http\Controllers\PrescriptionController;
use App\Http\Controllers\RadiologyOrderController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\SecondaryHealth\SecondaryDashboardController;
use App\Http\Controllers\StockTransferController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\SystemCorrectionController;
use App\Http\Controllers\SystemDataController;
use App\Http\Controllers\TriageController;
use App\Http\Controllers\UserCompanyAccessController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserModuleAccessController;
use App\Http\Middleware\EnsureModuleChosen;
use App\Http\Middleware\EnsurePatientReadyForTriage;
use App\Http\Middleware\EnsureSuperadmin;
use App\Http\Middleware\ShareActiveModule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

// Route::get('/', function () {
//     return Auth::check()
//         ? redirect()->route('dashboard')
//         : redirect()->route('login');
// })->name('home');

Route::get('/', function () {
    return Auth::check()
        ? redirect()->route('dashboard') // default flow goes to dashboard
        : redirect()->route('login');
})->name('home');

// Route::get('clinics/{clinic}/medication-request', [MedicationRequestController::class, 'indexJson']);
Route::post('/triages/close', [TriageController::class, 'bulkClose'])
    ->name('api.triages.bulk-close');

Route::middleware(['auth', 'verified', ShareActiveModule::class])->group(function () {

    Route::get('/kiosk', [KioskController::class, 'index'])->name('kiosk.index');
    Route::post('/kiosk/choose', [KioskController::class, 'choose'])->name('kiosk.choose');
    Route::post('/kiosk/reset', [KioskController::class, 'reset'])->name('kiosk.reset');

    Route::middleware([EnsureModuleChosen::class])->group(function () {

        Route::get('/users/{user}/module-access', [UserModuleAccessController::class, 'edit'])
            ->name('users.module-access.edit');

        Route::put('/users/{user}/module-access', [UserModuleAccessController::class, 'update'])
            ->name('users.module-access.update');

        // ───────────────────────────────
        // DENTAL MODULE
        // ───────────────────────────────
        // Dental
        Route::prefix('dental')->name('dental.')
            ->middleware(\App\Http\Middleware\EnsureDentalModule::class)
            ->group(function () {
                Route::get('/', [DentalDashboardController::class, 'index'])->name('dashboard');
            });

        // Chronics
        Route::prefix('chronics')->name('chronics.')
            ->middleware(\App\Http\Middleware\EnsureChronicsModule::class)
            ->group(function () {
                Route::get('/', [ChronicsDashboardController::class, 'index'])->name('dashboard');

                Route::get('/patients/{patient}/dispensations', [ChronicDispensationController::class, 'patientHistory'])
                    ->name('patients.dispensations.history');

                Route::get('/patients/{patient}/dispense', [ChronicDispensationController::class, 'showForm'])
                    ->name('chronics.patients.dispense');

                // NEW: batch store for chronic dispensing (route name used by your TSX)
                Route::post('/patients/{patient}/dispensations/batch', [ChronicDispensationController::class, 'storeBatch'])
                    ->name('dispensations.store.batch');

                // NEW: single-dispensation show
                Route::get('/dispensations/{dispensation}', [ChronicDispensationController::class, 'show'])
                    ->name('dispensations.show');

            });

        // Secondary Health
        Route::prefix('secondary')->name('secondary.')
            ->middleware(\App\Http\Middleware\EnsureSecondaryHealthModule::class)
            ->group(function () {
                Route::get('/', [SecondaryDashboardController::class, 'index'])
                    ->name('dashboard');

                // Add secondary-specific routes here, e.g.:
                // Route::resource('referrals', SecondaryReferralController::class);
            });

        // Medicals
        Route::prefix('medicals')->name('medicals.')
            ->middleware(\App\Http\Middleware\EnsureMedicalsModule::class)
            ->group(function () {
                Route::get('/', [MedicalsDashboardController::class, 'index'])
                    ->name('dashboard');

                // Companies (CRUD)
                Route::get('/companies', [\App\Http\Controllers\Medicals\CompanyController::class, 'index'])
                    ->name('companies.index');

                Route::get('/companies/create', [\App\Http\Controllers\Medicals\CompanyController::class, 'create'])
                    ->name('companies.create');

                Route::post('/companies', [\App\Http\Controllers\Medicals\CompanyController::class, 'store'])
                    ->name('companies.store');

                Route::get('/companies/{company}', [\App\Http\Controllers\Medicals\CompanyController::class, 'show'])
                    ->name('companies.show');

                Route::get('/companies/{company}/edit', [\App\Http\Controllers\Medicals\CompanyController::class, 'edit'])
                    ->name('companies.edit');

                Route::put('/companies/{company}', [\App\Http\Controllers\Medicals\CompanyController::class, 'update'])
                    ->name('companies.update');

                Route::delete('/companies/{company}', [\App\Http\Controllers\Medicals\CompanyController::class, 'destroy'])
                    ->name('companies.destroy');

                /*
                |-------------------------
                | Medicals • Attendees
                |-------------------------
                */
                Route::get('/attendees', [MedicalsAttendeeController::class, 'index'])->name('attendees.index');
                Route::get('/attendees/create', [MedicalsAttendeeController::class, 'create'])->name('attendees.create');
                Route::post('/attendees', [MedicalsAttendeeController::class, 'store'])->name('attendees.store');
                Route::get('/attendees/{attendee}', [MedicalsAttendeeController::class, 'show'])->name('attendees.show');
                Route::get('/attendees/{attendee}/edit', [MedicalsAttendeeController::class, 'edit'])->name('attendees.edit');
                Route::put('/attendees/{attendee}', [MedicalsAttendeeController::class, 'update'])->name('attendees.update');
                Route::delete('/attendees/{attendee}', [MedicalsAttendeeController::class, 'destroy'])->name('attendees.destroy');

                Route::get('/patients', [\App\Http\Controllers\Medicals\PatientsController::class, 'index'])
                    ->name('patients.index');
                Route::get('/patients/{patient}', [\App\Http\Controllers\Medicals\PatientsController::class, 'show'])
                    ->name('patients.show');
                Route::delete('/patients/{patient}', [\App\Http\Controllers\Medicals\PatientsController::class, 'destroy'])
                    ->name('patients.destroy');

                Route::get('/diseases', [DiseaseController::class, 'index'])->name('diseases.index');
                Route::get('/diseases/create', [DiseaseController::class, 'create'])->name('diseases.create');
                Route::post('/diseases', [DiseaseController::class, 'store'])->name('diseases.store');
                Route::get('/diseases/{disease}/edit', [DiseaseController::class, 'edit'])->name('diseases.edit');
                Route::patch('/diseases/{disease}', [DiseaseController::class, 'update'])->name('diseases.update');
                Route::delete('/diseases/{disease}', [DiseaseController::class, 'destroy'])->name('diseases.destroy');

                // ─────────────────────────────────────────
                // Illnesses (Inertia CRUD)
                // ─────────────────────────────────────────
                Route::get('/illnesses', [IllnessController::class, 'index'])
                    ->name('illnesses.index');

                Route::get('/illnesses/create', [IllnessController::class, 'create'])
                    ->name('illnesses.create');

                Route::post('/illnesses', [IllnessController::class, 'store'])
                    ->name('illnesses.store');

                Route::get('/illnesses/{illness}', [IllnessController::class, 'show'])
                    ->name('illnesses.show');

                Route::get('/illnesses/{illness}/edit', [IllnessController::class, 'edit'])
                    ->name('illnesses.edit');

                Route::match(['put', 'patch'], '/illnesses/{illness}', [IllnessController::class, 'update'])
                    ->name('illnesses.update');

                Route::delete('/illnesses/{illness}', [IllnessController::class, 'destroy'])
                    ->name('illnesses.destroy');

                // Update a single patient's pivot for a given illness (has_illness, treatment_year)
                Route::patch('/illnesses/{illness}/patients/{patient}', [IllnessController::class, 'updateIllness'])
                    ->name('illnesses.patient.update');

                // Skin Conditions CRUD
                Route::get('/skin-conditions', [SkinConditionController::class, 'index'])->name('skin-conditions.index');
                Route::get('/skin-conditions/create', [SkinConditionController::class, 'create'])->name('skin-conditions.create');
                Route::post('/skin-conditions', [SkinConditionController::class, 'store'])->name('skin-conditions.store');
                Route::get('/skin-conditions/{skinCondition}/edit', [SkinConditionController::class, 'edit'])->name('skin-conditions.edit');
                Route::patch('/skin-conditions/{skinCondition}', [SkinConditionController::class, 'update'])->name('skin-conditions.update');
                Route::delete('/skin-conditions/{skinCondition}', [SkinConditionController::class, 'destroy'])->name('skin-conditions.destroy');

                // Patient pivot update (attach/update condition for a patient)
                Route::post('/skin-conditions/{skinCondition}/patients/{patient}', [SkinConditionController::class, 'updatePatientSkinCondition'])
                    ->name('skin-conditions.pivot.update');

                Route::get('/auscultates', [\App\Http\Controllers\Medicals\AuscultateController::class, 'index'])->name('auscultates.index');
                Route::get('/auscultates/create', [\App\Http\Controllers\Medicals\AuscultateController::class, 'create'])->name('auscultates.create');
                Route::post('/auscultates', [\App\Http\Controllers\Medicals\AuscultateController::class, 'store'])->name('auscultates.store');
                Route::get('/auscultates/{auscultate}/edit', [\App\Http\Controllers\Medicals\AuscultateController::class, 'edit'])->name('auscultates.edit');
                Route::put('/auscultates/{auscultate}', [\App\Http\Controllers\Medicals\AuscultateController::class, 'update'])->name('auscultates.update');
                Route::delete('/auscultates/{auscultate}', [\App\Http\Controllers\Medicals\AuscultateController::class, 'destroy'])->name('auscultates.destroy');

                Route::get('/tobacco-uses', [\App\Http\Controllers\Medicals\TobaccoUseController::class, 'index'])->name('tobacco-uses.index');
                Route::get('/tobacco-uses/create', [\App\Http\Controllers\Medicals\TobaccoUseController::class, 'create'])->name('tobacco-uses.create');
                Route::post('/tobacco-uses', [\App\Http\Controllers\Medicals\TobaccoUseController::class, 'store'])->name('tobacco-uses.store');
                Route::get('/tobacco-uses/{tobacco_use}/edit', [\App\Http\Controllers\Medicals\TobaccoUseController::class, 'edit'])->name('tobacco-uses.edit');
                Route::put('/tobacco-uses/{tobacco_use}', [\App\Http\Controllers\Medicals\TobaccoUseController::class, 'update'])->name('tobacco-uses.update');
                Route::delete('/tobacco-uses/{tobacco_use}', [\App\Http\Controllers\Medicals\TobaccoUseController::class, 'destroy'])->name('tobacco-uses.destroy');

                Route::get('/pneumo', [\App\Http\Controllers\Medicals\PatientsController::class, 'pneumoPatients'])->name('pneumo');
                Route::get('/cofh', [\App\Http\Controllers\Medicals\PatientsController::class, 'cofhPatients'])->name('cofh');
                Route::get('/industry', [\App\Http\Controllers\Medicals\PatientsController::class, 'industryPatients'])->name('industry');
                Route::get('/exit-employment', [\App\Http\Controllers\Medicals\PatientsController::class, 'exitEmploymentPatients'])->name('exitEmployment');
                Route::get('/exit-pneumo', [\App\Http\Controllers\Medicals\PatientsController::class, 'exitPneumoPatients'])->name('exitPneumo');

                //Reports
                Route::get('/reports/generated', [\App\Http\Controllers\Medicals\ReportsController::class, 'generated'])
                    ->name('reports.generated');

                Route::get('/reports', [\App\Http\Controllers\Medicals\ReportsController::class, 'index'])->name('reports.index');
                // Optional JSON endpoints (if you want to fetch via JS later)
                Route::get('/reports/activity-by-day', [\App\Http\Controllers\Medicals\ReportsController::class, 'activityByDay'])->name('reports.activityByDay');
                Route::get('/reports/activity-by-day/report', [\App\Http\Controllers\Medicals\ReportsController::class, 'patientReportByDay'])->name('reports.patientReportByDay');

                Route::get('/reports/day/{day}', [\App\Http\Controllers\Medicals\ReportsController::class, 'day'])
                    ->name('reports.day');

                Route::get('/reports/corrections', [App\Http\Controllers\Medicals\ReportsController::class, 'corrections'])
                    ->name('reports.corrections');

                Route::patch('/reports/corrections/fix', [App\Http\Controllers\Medicals\ReportsController::class, 'fixCreatedAt'])
                    ->name('reports.corrections.fix');

                Route::get('/swabs', [App\Http\Controllers\Medicals\SwabController::class, 'index'])->name('swabs.index');
                Route::post('/swabs/filter', [App\Http\Controllers\Medicals\SwabController::class, 'getPatientsBySwabStatus'])->name('swabs.filter');

                Route::get('patients/{patient}/exams/start', [\App\Http\Controllers\Medicals\PhysicalExamController::class, 'start'])
                    ->name('exams.start');
                Route::post('patients/{patient}/exams', [\App\Http\Controllers\Medicals\PhysicalExamController::class, 'store'])
                    ->name('exams.store');
                Route::patch('exams/{exam}/second-bp', [\App\Http\Controllers\Medicals\PhysicalExamController::class, 'takeSecondBPReading'])
                    ->name('exams.second_bp');
                Route::patch('exams/{exam}/referral', [\App\Http\Controllers\Medicals\PhysicalExamController::class, 'addReferralComment'])
                    ->name('exams.referral');

                Route::patch('/patients/{patient}/certificate/status', [\App\Http\Controllers\Medicals\CertificateController::class, 'updateCertificateStatus'])
                    ->name('certificates.status.update');

                // Patients whose certificates are due within 30 days
                Route::get('/patients/due-medicals', [\App\Http\Controllers\Medicals\CertificateController::class, 'getPatientsWithDueMedicals'])
                    ->name('patients.due-medicals');

                // Doctor manual certificate update (password required)
                Route::patch('/certificates/{certificate}/manual-update', [\App\Http\Controllers\Medicals\CertificateController::class, 'doctorManualCertificateUpdate'])
                    ->name('certificates.manual-update');

                // Renew a patient’s medical certificate (with optional category update)
                Route::post('/patients/{patient}/certificate/renew', [\App\Http\Controllers\Medicals\CertificateController::class, 'renewMedicalCertificate'])
                    ->name('certificates.renew');

                // Simple renewal: create MedicalRecord + PENDING certificate
                Route::post('/patients/{patient}/certificate/renew-simple', [\App\Http\Controllers\Medicals\CertificateController::class, 'renewPatientCertificate'])
                    ->name('certificates.renew-simple');

            });

        Route::get('dashboard', function () {
            return Inertia::render('dashboard');
        })->name('dashboard');

        Route::impersonate();

        Route::get('/patients/bulk-import', [BulkUploadController::class, 'bulkImportForm'])
            ->name('bulk.import.form');

        Route::post('/patients/bulk-import/preview', [BulkUploadController::class, 'bulkImportPreview'])
            ->name('bulk.import.preview');

        Route::post('/patients/bulk-import/commit', [BulkUploadController::class, 'bulkImportCommit'])
            ->name('bulk.import.commit');

        Route::get('/bulk-import/download/{type}/{filename}', [BulkUploadController::class, 'downloadArtifact'])
            ->where('type', 'invalid|duplicates')
            ->where('filename', '[-A-Za-z0-9_.]+')
            ->name('bulk.import.download');

        //Superadmin Middleware
        Route::middleware([EnsureSuperadmin::class])->group(function () {
            Route::post('/patients/bulk-delete', [PatientController::class, 'bulkDestroy'])
                ->name('patients.bulk-destroy');
        });

        Route::get('/fund-members', [MedicalFundMemberController::class, 'index'])->name('fund_members.index');
        Route::post('/fund-members', [MedicalFundMemberController::class, 'store'])->name('fund_members.store');

        // Bulk import UI + actions
        Route::get('/fund-members/bulk', [MedicalFundMemberController::class, 'bulkForm'])->name('fund_members.bulk.form');
        Route::post('/fund-members/bulk/preview', [MedicalFundMemberController::class, 'bulkPreview'])->name('fund_members.bulk.preview');
        Route::post('/fund-members/bulk/commit', [MedicalFundMemberController::class, 'bulkCommit'])->name('fund_members.bulk.commit');

        Route::get('/fund-members/search', [MedicalFundMemberController::class, 'searchMembers'])
            ->name('fund_members.search');

        Route::post('/users/change-password-by-email', [UserController::class, 'changePasswordByEmail'])->name('users.changePasswordByEmail');

        Route::get('/daily/triages', [PatientController::class, 'currentDayTriages'])->name('daily.triages');
        Route::get('/triages/consultor/{id}', [TriageController::class, 'getByConsultor']);
        Route::get('/patients/stats', [PatientController::class, 'stats'])->name('patients.stats');
        Route::get('/dispensations/export', [DispensationController::class, 'export'])->name('dispensations.export');
        Route::get('/reports/consultations/export', [FileReportController::class, 'consultationsMonthly'])
            ->name('reports.consultations.export');

        Route::get('/api/companies', function () {
            return \App\Models\Company::select('id', 'name')->get();
        });

        Route::post('/consultations/{consultation}/close', [ConsultationController::class, 'closeConsultation'])
            ->name('consultations.close');

        Route::get('/consultations/{consultation}/dispensed/edit', [DispensationCorrectionController::class, 'editDispensed'])
            ->name('consultations.dispensed.edit');

        Route::get('/dispensations/{dispensation}/corrections/create', [DispensationCorrectionController::class, 'create'])
            ->name('dispensations.corrections.create');

        Route::post('/dispensations/{dispensation}/corrections', [DispensationCorrectionController::class, 'requestCorrection'])
            ->name('dispensations.corrections.store');

        Route::get('/patients/gender-distribution', [ReportsController::class, 'genderDistribution']);
        Route::get('/patients/employee-vs-dependents', [ReportsController::class, 'employeeVsDependents']);
        Route::get('/patients/age-range-distribution', [ReportsController::class, 'ageRangeDistribution']);
        Route::get('/consultations/sick-leave-per-month', [ReportsController::class, 'sickLeavePerMonth']);
        Route::get('/consultations/referrals-per-month', [ReportsController::class, 'referralsPerMonth']);
        Route::get('/consultations/injury-on-duty-cases', [ReportsController::class, 'injuryOnDutyCases']);

        Route::get('/reports/clinics', [ReportsController::class, 'getClinics'])->name('reports.clinics');
        Route::get('/reports/years', [ReportsController::class, 'getYears'])->name('reports.years');

        Route::resource('clinics', ClinicController::class);
        Route::resource('suppliers', SupplierController::class);
        Route::resource('central-stores', CentralStoreController::class);

        Route::get('/logs', [LogController::class, 'index'])->name('logs.index');

        Route::prefix('central-stores/{centralStore}')->group(function () {
            Route::get('receive-batch', [CentralStoreController::class, 'receiveBatchForm'])->name('central-stores.receive-batch.form');
            Route::post('receive-batch', [CentralStoreController::class, 'receiveBatch'])->name('central-stores.receive-batch.store');
            Route::get('received-batches', [CentralStoreController::class, 'receivedBatchesIndex'])->name('central-stores.received-batches.index');

            // NEW: delete a received batch
            Route::delete('received-batches/{batch}', [CentralStoreController::class, 'destroyReceivedBatch'])->name('central-stores.received-batches.destroy');

            Route::get('stock-transfers', [StockTransferController::class, 'index'])->name('central-stores.stock-transfers.index');
        });

        Route::get('/central-stores/{centralStore}/batches/{batch}/transfer',
            [CentralStoreController::class, 'transferStockForm'])
            ->name('central-stores.transfer-stock-form');

        Route::post('/central-stores/{centralStore}/batches/{batch}/transfer',
            [CentralStoreController::class, 'transferStock'])
            ->name('central-stores.transfer-stock');

        Route::post('/central-stores/{centralStore}/batches/{batch}/transf',
            [CentralStoreController::class, 'transferStockJson']);

        Route::post(
            '/nurse-medication-stocks/{nurseMedicationStock}/return',
            [NurseMedicationStockController::class, 'returnToClinic']
        )->name('nurse-medication-stocks.return');
        Route::post(
            '/central-stores/clinic-stocks/{clinicStock}/return',
            [CentralStoreController::class, 'returnFromClinicJson']
        )->name('central-stores.return-from-clinic');
        Route::post('/clinic-medication-stocks/{stock}/transfer-to-nurse', [NurseMedicationStockController::class, 'handleTransferToNurse']);
        Route::put('/clinic-medication-stocks/{stock}/update-quantity', [ClinicMedicationStockController::class, 'updateClinicMedQuantity']);
        Route::put('/nurse-medication-stocks/{nurseMedicationStock}/update-quantity', [NurseMedicationStockController::class, 'updateNurseMedQuantity']);
        Route::get('/nurse-medication-stocks/{user}', [NurseMedicationStockController::class, 'nurseMedicationStock'])
            ->name('nurse-medication-stocks.index');

        // Reports Section

        Route::get('/reports/nurse/stock-take', [NurseReportsController::class, 'nurseMedicationStockTake'])
            ->name('nurse-reports.stock-take');

        Route::get('/reports/clinics/{clinic}/stock-take', [ClinicReportsController::class, 'clinicMedicationStockTake'])
            ->name('clinic-reports.stock-take');

        Route::get('/reports/dispensations/monthly', [MonthlyDispenseReportController::class, 'monthly'])
            ->name('reports.dispensations.monthly')
            ->middleware(['auth']);

        Route::get('/reports/attendance/monthly', [MonthlyAttendanceReportController::class, 'monthly'])
            ->name('reports.attendance.monthly');

        Route::get('/reports/diagnosis/monthly', [DiagnosisReportController::class, 'monthly'])
            ->name('reports.diagnosis.monthly');

        // routes/web.php
        Route::get('/reports/sickleaves/monthly', [\App\Http\Controllers\SickLeaveReportController::class, 'monthly'])
            ->name('reports.sickleaves.monthly');

        Route::get('/reports/clinic-stock/all', [\App\Http\Controllers\ClinicStockTakeReportController::class, 'allClinicsStockTake'])
            ->name('reports.clinic.stock.all');

        // routes/web.php
        Route::get('/reports/iod/monthly', [\App\Http\Controllers\InjuryOnDutyController::class, 'monthly'])
            ->name('reports.iod.monthly');

        // routes/web.php
        Route::get('/reports/referrals/monthly', [\App\Http\Controllers\ReferralsReportController::class, 'monthly'])
            ->name('reports.referrals.monthly');

        Route::get('/reports/system-data', [SystemDataController::class, 'all'])
            ->name('reports.systemdata.all');
        // routes/web.php
        Route::get('/reports/nurse-stock/all', [\App\Http\Controllers\NurseStockTakeReportController::class, 'allUsersStockTake'])
            ->name('reports.nurse.stock.all');

        Route::get('/reports/dispensations/email-daily', [MonthlyDispenseReportController::class, 'emailDaily'])
            ->middleware(['auth']);

        Route::get('/reports/consultations/nurse-daily', [EmployeeReportsController::class, 'nurseDailyConsultationsExcel']);
        Route::get('/reports/consultations/nurse-daily/email', [EmployeeReportsController::class, 'emailNurseDailyConsultations']);
        // End of Reports Section

        Route::get(
            '/reports/central-stores/{centralStore}/batches',
            [CentralStoreReportsController::class, 'medicationBatchesReport']
        )->name('central-stores.received-batches.report');

        Route::prefix('clinics/{clinic}')->group(function () {
            // Medication Stocks routes
            Route::get('medication-stocks', [ClinicMedicationStockController::class, 'index'])
                ->name('clinics.medication-stocks.index');

            Route::post('medication-stocks', [ClinicMedicationStockController::class, 'store'])
                ->name('clinics.medication-stocks.store');

            Route::get('medication-stocks/create', [ClinicMedicationStockController::class, 'create'])
                ->name('clinics.medication-stocks.create');

            Route::get('medication-stocks/{stock}/edit', [ClinicMedicationStockController::class, 'edit'])
                ->name('clinics.medication-stocks.edit');

            Route::put('medication-stocks/{stock}', [ClinicMedicationStockController::class, 'update'])
                ->name('clinics.medication-stocks.update');

            Route::delete('medication-stocks/{stock}', [ClinicMedicationStockController::class, 'destroy'])
                ->name('clinics.medication-stocks.destroy');

            Route::get('pending-stock-transfers', [ClinicMedicationStockController::class, 'pendingStockTransfers'])->name('clinics.pending-stock-transfers');

            Route::get('pending-stock-transfers/count', [ClinicMedicationStockController::class, 'countPendingStockTransfers'])
                ->name('clinics.pending-stock-transfers.count');

            Route::post('stock-transfers/{stockTransferId}/approve', [StockTransferController::class, 'approveStockTransfer'])->name('clinics.stock-transfers.approve');

            Route::get('request-medication', [MedicationRequestController::class, 'create'])->name('clinics.request-medication.create');

            Route::get('medication-requests', [MedicationRequestController::class, 'index'])->name('clinics.medication-requests.index');
            Route::post('medication-requests', [MedicationRequestController::class, 'store'])->name('clinics.medication-requests.store');
            Route::post('medication-requests/{request}/approve', [MedicationRequestController::class, 'approve'])->name('clinics.medication-requests.approve');

        });

        Route::get('/medication-requests', [MedicationRequestController::class, 'indexAll'])->name('medication-requests.indexAll');
        Route::put('/medication-requests/{medicationRequest}', [MedicationRequestController::class, 'update'])->name('medication-requests.update');
        Route::delete('/medication-requests/{medicationRequest}', [MedicationRequestController::class, 'destroy'])->name('medication-requests.destroy');

        Route::resource('users', UserController::class);

        Route::delete('/users/{user}', [\App\Http\Controllers\UserController::class, 'destroy'])
            ->name('users.destroy');

        Route::resource('companies', CompanyController::class);
        Route::resource('medications', MedicationController::class);
        // Patients resource for main patients
        Route::resource('patients', PatientController::class);
        Route::resource('diagnosis-presets', DiagnosisPresetController::class);

        Route::get('/patients/create', [PatientController::class, 'create'])->name('patients.create');
        Route::post('/patients', [PatientController::class, 'store'])->name('patients.store');
        Route::delete('/patients/{id}', [PatientController::class, 'destroy'])
            ->name('delete.destroy');

        Route::get('/patient/search', [PatientController::class, 'searchPage'])->name('patient.search');
        Route::get('/patient/find', [PatientController::class, 'search'])->name('patient.find');
        Route::get('/patients/{patient}/edit', [PatientController::class, 'edit'])->name('patients.edit');
        Route::put('/patients/{patient}', [PatientController::class, 'update'])->name('patients.update');

        // Dependents index, create, edit, update, destroy routes
        Route::get('dependents', [PatientController::class, 'dependentsIndex'])->name('dependents.index');
        Route::get('dependents/create', [PatientController::class, 'createDependent'])->name('dependents.create');
        Route::post('dependents', [PatientController::class, 'storeDependent'])->name('dependents.store');
        Route::delete('dependents/{dependent}', [PatientController::class, 'destroyDependent'])->name('dependents.destroy');
        Route::get('/dependents/{dependent}', [PatientController::class, 'showDependent'])->name('dependents.show');
        Route::get('/dependents/{dependent}/edit', [PatientController::class, 'editDependent'])->name('dependents.edit');
        Route::put('/dependents/{dependent}', [PatientController::class, 'updateDependent'])->name('dependents.update');

        Route::get('/patients/{patient}/consultations', [ConsultationController::class, 'patientConsultations'])
            ->name('patients.consultations');
        // Consultation routes
        Route::get('/consultations/create', [ConsultationController::class, 'create'])->name('consultations.create');
        Route::get('/consultations', [ConsultationController::class, 'index'])->name('consultations.index');

        Route::post('/consultations', [ConsultationController::class, 'store'])->name('consultations.store');
        Route::get('/consultations/{consultation}', [ConsultationController::class, 'show'])->name('consultations.show');
        Route::get('/consultations/{consultation}/edit', [ConsultationController::class, 'edit'])->name('consultations.edit');
        Route::put('/consultations/{consultation}', [ConsultationController::class, 'update'])->name('consultations.update');
        Route::get('/consultations/{consultation}/dispense', [ConsultationController::class, 'showDispenseForm'])->name('consultations.dispense');

        Route::get('/consultations/{consultation}/referrals', [ConsultationController::class, 'editReferrals'])
            ->name('consultations.referrals.edit');

        Route::patch('/consultations/{consultation}/referrals', [ConsultationController::class, 'updateReferrals'])
            ->name('consultations.referrals.update');

        Route::get('/consultations/{consultation}/transfer', [ConsultationController::class, 'transferForm'])
            ->name('consultations.transfer.form');
        Route::post('/consultations/{consultation}/transfer', [ConsultationController::class, 'transferPatient'])
            ->name('consultations.transfer');

        Route::prefix('doctor-notes')->group(function () {
            Route::get('/', [DoctorNoteController::class, 'index'])->name('doctor-notes.index');
            Route::post('/', [DoctorNoteController::class, 'store'])->name('doctor-notes.store');
            Route::get('/{doctorNote}', [DoctorNoteController::class, 'show'])->name('doctor-notes.show');
            Route::get('/{doctorNote}/edit', [DoctorNoteController::class, 'edit'])->name('doctor-notes.edit');
            Route::put('/{doctorNote}', [DoctorNoteController::class, 'update'])->name('doctor-notes.update');
            Route::delete('/{doctorNote}', [DoctorNoteController::class, 'destroy'])->name('doctor-notes.destroy');
        });

        // If you want a route to create a note specifically for a consultation
        Route::get('/consultations/{consultation}/doctor-notes/create', [DoctorNoteController::class, 'createForConsultation'])
            ->name('consultations.doctor-notes.create');

        Route::get('/consultations/{consultation}/dispensations', [DispensationController::class, 'index'])
            ->name('consultations.dispensations.index');

        Route::post('/consultations/{consultation}/dispensations', [DispensationController::class, 'store'])
            ->name('consultations.dispensations.store');

        Route::get('/reports/dispensations', [NurseReportsController::class, 'dispensationsReport'])
            ->name('dispensations.report');

        Route::post('/dispensations', [DispensationController::class, 'store'])->name('dispensations.store');
        Route::get('/dispensations', [DispensationController::class, 'allDispensations'])->name('dispensations.all');
        // Reports
        Route::get('/reports/consultations/monthly', [App\Http\Controllers\ReportsController::class, 'monthlyConsultations']);

        // Radiology Orders
        Route::prefix('consultations/{consultation}/radiology-orders')->group(function () {
            Route::get('create', [RadiologyOrderController::class, 'create'])->name('radiology-orders.create');
            Route::post('', [RadiologyOrderController::class, 'store'])->name('radiology-orders.store');
        });

        // Lab Tests (linked to consultations)
        Route::prefix('consultations/{consultation}/lab-tests')->group(function () {
            Route::get('create', [LabTestController::class, 'create'])->name('lab-tests.create');
            Route::post('/', [LabTestController::class, 'store'])->name('lab-tests.store');
        });

// Editing/updating existing lab tests
        Route::prefix('lab-tests/{labTest}')->group(function () {
            Route::get('edit', [LabTestController::class, 'edit'])->name('lab-tests.edit');
            Route::put('/', [LabTestController::class, 'update'])->name('lab-tests.update');
        });

        Route::middleware([EnsurePatientReadyForTriage::class])->group(function () {
            Route::get('/triages/create', [TriageController::class, 'create'])->name('triages.create');
        });

        Route::post('/triages', [TriageController::class, 'store'])->name('triages.store');

        Route::get('/triages/{triage}/edit', [TriageController::class, 'edit'])->name('triages.edit');
        Route::put('/triages/{triage}', [TriageController::class, 'update'])->name('triages.update');

        Route::get('/triages/{triage}', [TriageController::class, 'show'])->name('triages.show');
        Route::get('/triages', [TriageController::class, 'index'])->name('triages.index');

        Route::get('consultations/{consultation}/prescriptions/create', [PrescriptionController::class, 'create'])
            ->name('consultations.prescriptions.create');

        Route::resource('prescriptions', PrescriptionController::class)->except(['index']);
        Route::get('patients/{patient}/prescriptions', [PrescriptionController::class, 'patientPrescriptions'])
            ->name('patients.prescriptions');

        Route::get('/reports', [ReportsController::class, 'index'])->name('reports.index');
        // If you need a standalone prescriptions index
        Route::get('prescriptions', [PrescriptionController::class, 'index'])
            ->name('prescriptions.index');

        Route::get('/triages', [TriageController::class, 'index'])->name('triages.index');

        // Reports portal page
        Route::get('/reports/portal', [PayrollReportsController::class, 'portal'])
            ->name('reports.portal');

        // Payroll monthly Excel
        Route::get('/reports/payroll/monthly', [PayrollReportsController::class, 'payrollMonthly'])
            ->name('reports.payroll.monthly');

        Route::get('/reports/diagnosis/monthly', [MonthlyAilmentsController::class, 'monthly'])
            ->name('reports.diagnosis.monthly');

        Route::get('/reports/payroll/dependents-by-company', [PayrollReportsController::class, 'payrollMonthlyDependentsByCompany'])
            ->name('reports.payroll.dependents-by-company');

        // NEW: Zip—one XLSX per company (dependents only) bundled together
        Route::get('/reports/payroll/dependents-zip-by-company', [PayrollReportsController::class, 'payrollMonthlyDependentsZipByCompany'])
            ->name('reports.payroll.dependents-zip-by-company');

        Route::get(
            '/central-stores/{centralStore}/batches/{batch}/edit',
            [CentralStoreController::class, 'editReceivedBatch']
        )->name('central-stores.received-batches.edit');

        Route::put(
            '/central-stores/{centralStore}/batches/{batch}',
            [CentralStoreController::class, 'updateReceivedBatch']
        )->name('central-stores.received-batches.update');

        //Correct Dispensed Medication
        Route::get('/corrections', [DispensationCorrectionController::class, 'index'])
            ->name('corrections.index');

        // Route::post('/dispensations/{dispensation}/corrections', [DispensationCorrectionController::class, 'requestCorrection']);
        // Route::post('/corrections/{correction}/approve', [DispensationCorrectionController::class, 'approveCorrection']);
        // Route::post('/corrections/{correction}/reject', [DispensationCorrectionController::class, 'rejectCorrection']);

        // Already have (from earlier):
        Route::post('/dispensations/{dispensation}/corrections', [DispensationCorrectionController::class, 'requestCorrection'])
            ->name('dispensations.corrections.store');

        Route::post('/corrections/{correction}/approve', [DispensationCorrectionController::class, 'approveCorrection'])
            ->name('corrections.approve');

        Route::delete(
            '/dispensations/{dispensation}/return-to-stock',
            [DispensationCorrectionController::class, 'deleteAndReturn']
        )->name('dispensations.delete_return');

        Route::post('/corrections/{correction}/reject', [DispensationCorrectionController::class, 'rejectCorrection'])
            ->name('corrections.reject');

        //User Clinic Access Management
        Route::get('/users/{user}/clinic-access', [ClinicAccessController::class, 'edit'])->name('users.clinic-access.edit');
        Route::put('/users/{user}/clinic-access', [ClinicAccessController::class, 'update'])->name('users.clinic-access.update');

        Route::post('/users/{user}/clinic-access', [ClinicAccessController::class, 'store'])
            ->name('users.clinic-access.store');

        Route::delete('/users/{user}/clinic-access/{clinic}', [ClinicAccessController::class, 'destroy'])
            ->name('users.clinic-access.destroy');

        // 7-day check-ins + today's consultations per clinic
        Route::get('/reports/dashboard-data', [DashboardReportsController::class, 'weeklySummary'])
            ->name('reports.weekly');

        // Today's triages list (your page already calls this name)
        Route::get('/reports/today-triages', [DashboardReportsController::class, 'todayTriages'])
            ->name('daily.triages');

        Route::get('/reports/nurse', [NurseDashboardReportsController::class, 'index'])
            ->name('nurse.reports');

        Route::get('/api/reports/consultor/summary', [NurseDashboardReportsController::class, 'stats'])
            ->name('consultor.reports.stats');

        /* -------- Imaging -------- */
        // Override create/edit to carry consultation & patient in the URL
        Route::get('referrals/imaging/create/{consultation}/{patient}', [ImagingReferralController::class, 'create'])
            ->name('referrals.imaging.create');

        Route::get('referrals/imaging/{imagingReferral}/edit/{consultation?}/{patient?}', [ImagingReferralController::class, 'edit'])
            ->name('referrals.imaging.edit');

        // Rest of resource (excluding create/edit)
        Route::resource('referrals/imaging', ImagingReferralController::class)
            ->except(['create', 'edit'])
            ->parameters(['imaging' => 'imagingReferral'])
            ->names('referrals.imaging');

        /* -------- Lab -------- */
        Route::get('referrals/lab/create/{consultation}/{patient}', [LabReferralController::class, 'create'])
            ->name('referrals.lab.create');

        Route::get('referrals/lab/{labReferral}/edit/{consultation?}/{patient?}', [LabReferralController::class, 'edit'])
            ->name('referrals.lab.edit');

        Route::resource('referrals/lab', LabReferralController::class)
            ->except(['create', 'edit'])
            ->parameters(['lab' => 'labReferral'])
            ->names('referrals.lab');

        Route::get('/duplicates', [DuplicatePatientController::class, 'index'])->name('duplicates.index');
        Route::post('/duplicates/merge', [DuplicatePatientController::class, 'merge'])->name('duplicates.merge');

        Route::post(
            '/consultations/{consultation}/dispensations/batch',
            [\App\Http\Controllers\DispensationController::class, 'storeBatch']
        )->name('consultations.dispensations.store.batch');

        Route::get('/users/{user}/company-access', [UserCompanyAccessController::class, 'edit'])
            ->name('users.company-access.edit');

        Route::put('/users/{user}/company-access', [UserCompanyAccessController::class, 'update'])
            ->name('users.company-access.update');

        Route::post('/users/{user}/company-access', [UserCompanyAccessController::class, 'store'])
            ->name('users.company-access.store');

        Route::delete('/users/{user}/company-access/{company}', [UserCompanyAccessController::class, 'destroy'])
            ->name('users.company-access.destroy');

        // ===============================
        // Chronic Patients Routes
        // ===============================

        // Import controller at the top of the file:
        // use App\Http\Controllers\Chronics\ChronicsPatientsController;

        // Route to list all patients marked as chronic
        // URL: /chronics/patients
        // Controller: ChronicsPatientsController@index
        // Name: chronics.patients.index
        Route::get('/chronics/patients', [ChronicsPatientsController::class, 'index'])
            ->name('chronics.patients.index');

        Route::get('/system-corrections/employees-without-gender', [SystemCorrectionController::class, 'employeesWithoutGender'])
            ->name('system-corrections.employees-without-gender');

        Route::post('/system-corrections/gender/bulk', [SystemCorrectionController::class, 'bulkAssignGender'])
            ->name('system-corrections.gender.bulk');

    });

});

require __DIR__ . '/settings.php';
require __DIR__ . '/auth.php';
require __DIR__ . '/api.php';
